@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.SubscriberArgs.builder
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberSourceArgs
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberSourceArgsBuilder
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberSubscriberIdentityArgs
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberSubscriberIdentityArgsBuilder
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberTimeoutsArgs
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Security Lake Subscriber.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating the `aws.securitylake.Subscriber`. Use a `depends_on` statement.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.Subscriber("example", {
 *     subscriberName: "example-name",
 *     accessType: "S3",
 *     source: {
 *         awsLogSourceResource: {
 *             sourceName: "ROUTE53",
 *             sourceVersion: "1.0",
 *         },
 *     },
 *     subscriberIdentity: {
 *         externalId: "example",
 *         principal: "1234567890",
 *     },
 * }, {
 *     dependsOn: [exampleAwsSecuritylakeDataLake],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.Subscriber("example",
 *     subscriber_name="example-name",
 *     access_type="S3",
 *     source={
 *         "aws_log_source_resource": {
 *             "source_name": "ROUTE53",
 *             "source_version": "1.0",
 *         },
 *     },
 *     subscriber_identity={
 *         "external_id": "example",
 *         "principal": "1234567890",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.Subscriber("example", new()
 *     {
 *         SubscriberName = "example-name",
 *         AccessType = "S3",
 *         Source = new Aws.SecurityLake.Inputs.SubscriberSourceArgs
 *         {
 *             AwsLogSourceResource = new Aws.SecurityLake.Inputs.SubscriberSourceAwsLogSourceResourceArgs
 *             {
 *                 SourceName = "ROUTE53",
 *                 SourceVersion = "1.0",
 *             },
 *         },
 *         SubscriberIdentity = new Aws.SecurityLake.Inputs.SubscriberSubscriberIdentityArgs
 *         {
 *             ExternalId = "example",
 *             Principal = "1234567890",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSecuritylakeDataLake,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewSubscriber(ctx, "example", &securitylake.SubscriberArgs{
 * 			SubscriberName: pulumi.String("example-name"),
 * 			AccessType:     pulumi.String("S3"),
 * 			Source: &securitylake.SubscriberSourceArgs{
 * 				AwsLogSourceResource: &securitylake.SubscriberSourceAwsLogSourceResourceArgs{
 * 					SourceName:    pulumi.String("ROUTE53"),
 * 					SourceVersion: pulumi.String("1.0"),
 * 				},
 * 			},
 * 			SubscriberIdentity: &securitylake.SubscriberSubscriberIdentityArgs{
 * 				ExternalId: pulumi.String("example"),
 * 				Principal:  pulumi.String("1234567890"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSecuritylakeDataLake,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.Subscriber;
 * import com.pulumi.aws.securitylake.SubscriberArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberSourceArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberSourceAwsLogSourceResourceArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberSubscriberIdentityArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Subscriber("example", SubscriberArgs.builder()
 *             .subscriberName("example-name")
 *             .accessType("S3")
 *             .source(SubscriberSourceArgs.builder()
 *                 .awsLogSourceResource(SubscriberSourceAwsLogSourceResourceArgs.builder()
 *                     .sourceName("ROUTE53")
 *                     .sourceVersion("1.0")
 *                     .build())
 *                 .build())
 *             .subscriberIdentity(SubscriberSubscriberIdentityArgs.builder()
 *                 .externalId("example")
 *                 .principal("1234567890")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSecuritylakeDataLake)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:Subscriber
 *     properties:
 *       subscriberName: example-name
 *       accessType: S3
 *       source:
 *         awsLogSourceResource:
 *           sourceName: ROUTE53
 *           sourceVersion: '1.0'
 *       subscriberIdentity:
 *         externalId: example
 *         principal: '1234567890'
 *     options:
 *       dependson:
 *         - ${exampleAwsSecuritylakeDataLake}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Lake subscriber using the subscriber ID. For example:
 * ```sh
 * $ pulumi import aws:securitylake/subscriber:Subscriber example 9f3bfe79-d543-474d-a93c-f3846805d208
 * ```
 * @property accessType The Amazon S3 or Lake Formation access type.
 * @property source The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
 * @property subscriberDescription The description for your subscriber account in Security Lake.
 * @property subscriberIdentity The AWS identity used to access your data. See `subscriber_identity` Block below.
 * @property subscriberName The name of your Security Lake subscriber account.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class SubscriberArgs(
    public val accessType: Output<String>? = null,
    public val source: Output<SubscriberSourceArgs>? = null,
    public val subscriberDescription: Output<String>? = null,
    public val subscriberIdentity: Output<SubscriberSubscriberIdentityArgs>? = null,
    public val subscriberName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<SubscriberTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.SubscriberArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.SubscriberArgs =
        com.pulumi.aws.securitylake.SubscriberArgs.builder()
            .accessType(accessType?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriberDescription(subscriberDescription?.applyValue({ args0 -> args0 }))
            .subscriberIdentity(
                subscriberIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subscriberName(subscriberName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SubscriberArgs].
 */
@PulumiTagMarker
public class SubscriberArgsBuilder internal constructor() {
    private var accessType: Output<String>? = null

    private var source: Output<SubscriberSourceArgs>? = null

    private var subscriberDescription: Output<String>? = null

    private var subscriberIdentity: Output<SubscriberSubscriberIdentityArgs>? = null

    private var subscriberName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<SubscriberTimeoutsArgs>? = null

    /**
     * @param value The Amazon S3 or Lake Formation access type.
     */
    @JvmName("qsqgjakqntvakwnb")
    public suspend fun accessType(`value`: Output<String>) {
        this.accessType = value
    }

    /**
     * @param value The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
     */
    @JvmName("mdhrjyudohqewcku")
    public suspend fun source(`value`: Output<SubscriberSourceArgs>) {
        this.source = value
    }

    /**
     * @param value The description for your subscriber account in Security Lake.
     */
    @JvmName("dyqrnrpfhcstigse")
    public suspend fun subscriberDescription(`value`: Output<String>) {
        this.subscriberDescription = value
    }

    /**
     * @param value The AWS identity used to access your data. See `subscriber_identity` Block below.
     */
    @JvmName("ovardkiwuabutqbn")
    public suspend fun subscriberIdentity(`value`: Output<SubscriberSubscriberIdentityArgs>) {
        this.subscriberIdentity = value
    }

    /**
     * @param value The name of your Security Lake subscriber account.
     */
    @JvmName("jcdxqwxeksesknfq")
    public suspend fun subscriberName(`value`: Output<String>) {
        this.subscriberName = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("axlebyrbnmiaphvi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("aetnuhopvtrhyuyc")
    public suspend fun timeouts(`value`: Output<SubscriberTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon S3 or Lake Formation access type.
     */
    @JvmName("inkjopvdygdwwmye")
    public suspend fun accessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
     */
    @JvmName("drboeekaubyagjbh")
    public suspend fun source(`value`: SubscriberSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
     */
    @JvmName("xvwsxlwtpgbcbhmg")
    public suspend fun source(argument: suspend SubscriberSourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriberSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value The description for your subscriber account in Security Lake.
     */
    @JvmName("fwytxqehwrwekrmq")
    public suspend fun subscriberDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberDescription = mapped
    }

    /**
     * @param value The AWS identity used to access your data. See `subscriber_identity` Block below.
     */
    @JvmName("evftbrcatvrtdhdr")
    public suspend fun subscriberIdentity(`value`: SubscriberSubscriberIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberIdentity = mapped
    }

    /**
     * @param argument The AWS identity used to access your data. See `subscriber_identity` Block below.
     */
    @JvmName("jgmaqcgrodbvpujj")
    public suspend fun subscriberIdentity(argument: suspend SubscriberSubscriberIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriberSubscriberIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subscriberIdentity = mapped
    }

    /**
     * @param value The name of your Security Lake subscriber account.
     */
    @JvmName("hogyjcvnpsayldwu")
    public suspend fun subscriberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberName = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hlxmjabsjrsltwen")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dwsygnnkbnyxaruv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("mxrhrcfbbnnwiiqd")
    public suspend fun timeouts(`value`: SubscriberTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ktcadspijhtwbaln")
    public suspend fun timeouts(argument: suspend SubscriberTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriberTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): SubscriberArgs = SubscriberArgs(
        accessType = accessType,
        source = source,
        subscriberDescription = subscriberDescription,
        subscriberIdentity = subscriberIdentity,
        subscriberName = subscriberName,
        tags = tags,
        timeouts = timeouts,
    )
}
