@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberNotificationConfiguration
import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberNotificationConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SubscriberNotification].
 */
@PulumiTagMarker
public class SubscriberNotificationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubscriberNotificationArgs = SubscriberNotificationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubscriberNotificationArgsBuilder.() -> Unit) {
        val builder = SubscriberNotificationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SubscriberNotification {
        val builtJavaResource =
            com.pulumi.aws.securitylake.SubscriberNotification(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SubscriberNotification(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Security Lake Subscriber Notification.
 * ## Example Usage
 * ### SQS Notification
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.SubscriberNotification("example", {
 *     subscriberId: exampleAwsSecuritylakeSubscriber.id,
 *     configuration: {
 *         sqsNotificationConfiguration: {},
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.SubscriberNotification("example",
 *     subscriber_id=example_aws_securitylake_subscriber["id"],
 *     configuration={
 *         "sqs_notification_configuration": {},
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.SubscriberNotification("example", new()
 *     {
 *         SubscriberId = exampleAwsSecuritylakeSubscriber.Id,
 *         Configuration = new Aws.SecurityLake.Inputs.SubscriberNotificationConfigurationArgs
 *         {
 *             SqsNotificationConfiguration = null,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewSubscriberNotification(ctx, "example", &securitylake.SubscriberNotificationArgs{
 * 			SubscriberId: pulumi.Any(exampleAwsSecuritylakeSubscriber.Id),
 * 			Configuration: &securitylake.SubscriberNotificationConfigurationArgs{
 * 				SqsNotificationConfiguration: nil,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.SubscriberNotification;
 * import com.pulumi.aws.securitylake.SubscriberNotificationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationSqsNotificationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubscriberNotification("example", SubscriberNotificationArgs.builder()
 *             .subscriberId(exampleAwsSecuritylakeSubscriber.id())
 *             .configuration(SubscriberNotificationConfigurationArgs.builder()
 *                 .sqsNotificationConfiguration()
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:SubscriberNotification
 *     properties:
 *       subscriberId: ${exampleAwsSecuritylakeSubscriber.id}
 *       configuration:
 *         sqsNotificationConfiguration: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### HTTPS Notification
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.SubscriberNotification("example", {
 *     subscriberId: exampleAwsSecuritylakeSubscriber.id,
 *     configuration: {
 *         httpsNotificationConfiguration: {
 *             endpoint: test.apiEndpoint,
 *             targetRoleArn: eventBridge.arn,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.SubscriberNotification("example",
 *     subscriber_id=example_aws_securitylake_subscriber["id"],
 *     configuration={
 *         "https_notification_configuration": {
 *             "endpoint": test["apiEndpoint"],
 *             "target_role_arn": event_bridge["arn"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.SubscriberNotification("example", new()
 *     {
 *         SubscriberId = exampleAwsSecuritylakeSubscriber.Id,
 *         Configuration = new Aws.SecurityLake.Inputs.SubscriberNotificationConfigurationArgs
 *         {
 *             HttpsNotificationConfiguration = new Aws.SecurityLake.Inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs
 *             {
 *                 Endpoint = test.ApiEndpoint,
 *                 TargetRoleArn = eventBridge.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewSubscriberNotification(ctx, "example", &securitylake.SubscriberNotificationArgs{
 * 			SubscriberId: pulumi.Any(exampleAwsSecuritylakeSubscriber.Id),
 * 			Configuration: &securitylake.SubscriberNotificationConfigurationArgs{
 * 				HttpsNotificationConfiguration: &securitylake.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs{
 * 					Endpoint:      pulumi.Any(test.ApiEndpoint),
 * 					TargetRoleArn: pulumi.Any(eventBridge.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.SubscriberNotification;
 * import com.pulumi.aws.securitylake.SubscriberNotificationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubscriberNotification("example", SubscriberNotificationArgs.builder()
 *             .subscriberId(exampleAwsSecuritylakeSubscriber.id())
 *             .configuration(SubscriberNotificationConfigurationArgs.builder()
 *                 .httpsNotificationConfiguration(SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs.builder()
 *                     .endpoint(test.apiEndpoint())
 *                     .targetRoleArn(eventBridge.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:SubscriberNotification
 *     properties:
 *       subscriberId: ${exampleAwsSecuritylakeSubscriber.id}
 *       configuration:
 *         httpsNotificationConfiguration:
 *           endpoint: ${test.apiEndpoint}
 *           targetRoleArn: ${eventBridge.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class SubscriberNotification internal constructor(
    override val javaResource: com.pulumi.aws.securitylake.SubscriberNotification,
) : KotlinCustomResource(javaResource, SubscriberNotificationMapper) {
    /**
     * Specify the configuration using which you want to create the subscriber notification..
     */
    public val configuration: Output<SubscriberNotificationConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * (**Deprecated**) The subscriber endpoint to which exception messages are posted.
     */
    @Deprecated(
        message = """
  Use subscriber_endpoint instead
  """,
    )
    public val endpointId: Output<String>
        get() = javaResource.endpointId().applyValue({ args0 -> args0 })

    /**
     * The subscriber endpoint to which exception messages are posted.
     */
    public val subscriberEndpoint: Output<String>
        get() = javaResource.subscriberEndpoint().applyValue({ args0 -> args0 })

    /**
     * The subscriber ID for the notification subscription.
     */
    public val subscriberId: Output<String>
        get() = javaResource.subscriberId().applyValue({ args0 -> args0 })
}

public object SubscriberNotificationMapper : ResourceMapper<SubscriberNotification> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securitylake.SubscriberNotification::class == javaResource::class

    override fun map(javaResource: Resource): SubscriberNotification =
        SubscriberNotification(javaResource as com.pulumi.aws.securitylake.SubscriberNotification)
}

/**
 * @see [SubscriberNotification].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubscriberNotification].
 */
public suspend fun subscriberNotification(
    name: String,
    block: suspend SubscriberNotificationResourceBuilder.() -> Unit,
): SubscriberNotification {
    val builder = SubscriberNotificationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubscriberNotification].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subscriberNotification(name: String): SubscriberNotification {
    val builder = SubscriberNotificationResourceBuilder()
    builder.name(name)
    return builder.build()
}
