@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.SubscriberNotificationArgs.builder
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberNotificationConfigurationArgs
import com.pulumi.aws.securitylake.kotlin.inputs.SubscriberNotificationConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Security Lake Subscriber Notification.
 * ## Example Usage
 * ### SQS Notification
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.SubscriberNotification("example", {
 *     subscriberId: exampleAwsSecuritylakeSubscriber.id,
 *     configuration: {
 *         sqsNotificationConfiguration: {},
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.SubscriberNotification("example",
 *     subscriber_id=example_aws_securitylake_subscriber["id"],
 *     configuration={
 *         "sqs_notification_configuration": {},
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.SubscriberNotification("example", new()
 *     {
 *         SubscriberId = exampleAwsSecuritylakeSubscriber.Id,
 *         Configuration = new Aws.SecurityLake.Inputs.SubscriberNotificationConfigurationArgs
 *         {
 *             SqsNotificationConfiguration = null,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewSubscriberNotification(ctx, "example", &securitylake.SubscriberNotificationArgs{
 * 			SubscriberId: pulumi.Any(exampleAwsSecuritylakeSubscriber.Id),
 * 			Configuration: &securitylake.SubscriberNotificationConfigurationArgs{
 * 				SqsNotificationConfiguration: nil,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.SubscriberNotification;
 * import com.pulumi.aws.securitylake.SubscriberNotificationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationSqsNotificationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubscriberNotification("example", SubscriberNotificationArgs.builder()
 *             .subscriberId(exampleAwsSecuritylakeSubscriber.id())
 *             .configuration(SubscriberNotificationConfigurationArgs.builder()
 *                 .sqsNotificationConfiguration()
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:SubscriberNotification
 *     properties:
 *       subscriberId: ${exampleAwsSecuritylakeSubscriber.id}
 *       configuration:
 *         sqsNotificationConfiguration: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### HTTPS Notification
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.SubscriberNotification("example", {
 *     subscriberId: exampleAwsSecuritylakeSubscriber.id,
 *     configuration: {
 *         httpsNotificationConfiguration: {
 *             endpoint: test.apiEndpoint,
 *             targetRoleArn: eventBridge.arn,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.SubscriberNotification("example",
 *     subscriber_id=example_aws_securitylake_subscriber["id"],
 *     configuration={
 *         "https_notification_configuration": {
 *             "endpoint": test["apiEndpoint"],
 *             "target_role_arn": event_bridge["arn"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.SubscriberNotification("example", new()
 *     {
 *         SubscriberId = exampleAwsSecuritylakeSubscriber.Id,
 *         Configuration = new Aws.SecurityLake.Inputs.SubscriberNotificationConfigurationArgs
 *         {
 *             HttpsNotificationConfiguration = new Aws.SecurityLake.Inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs
 *             {
 *                 Endpoint = test.ApiEndpoint,
 *                 TargetRoleArn = eventBridge.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewSubscriberNotification(ctx, "example", &securitylake.SubscriberNotificationArgs{
 * 			SubscriberId: pulumi.Any(exampleAwsSecuritylakeSubscriber.Id),
 * 			Configuration: &securitylake.SubscriberNotificationConfigurationArgs{
 * 				HttpsNotificationConfiguration: &securitylake.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs{
 * 					Endpoint:      pulumi.Any(test.ApiEndpoint),
 * 					TargetRoleArn: pulumi.Any(eventBridge.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.SubscriberNotification;
 * import com.pulumi.aws.securitylake.SubscriberNotificationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubscriberNotification("example", SubscriberNotificationArgs.builder()
 *             .subscriberId(exampleAwsSecuritylakeSubscriber.id())
 *             .configuration(SubscriberNotificationConfigurationArgs.builder()
 *                 .httpsNotificationConfiguration(SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs.builder()
 *                     .endpoint(test.apiEndpoint())
 *                     .targetRoleArn(eventBridge.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:SubscriberNotification
 *     properties:
 *       subscriberId: ${exampleAwsSecuritylakeSubscriber.id}
 *       configuration:
 *         httpsNotificationConfiguration:
 *           endpoint: ${test.apiEndpoint}
 *           targetRoleArn: ${eventBridge.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property configuration Specify the configuration using which you want to create the subscriber notification..
 * @property subscriberId The subscriber ID for the notification subscription.
 */
public data class SubscriberNotificationArgs(
    public val configuration: Output<SubscriberNotificationConfigurationArgs>? = null,
    public val subscriberId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.SubscriberNotificationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.SubscriberNotificationArgs =
        com.pulumi.aws.securitylake.SubscriberNotificationArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriberId(subscriberId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberNotificationArgs].
 */
@PulumiTagMarker
public class SubscriberNotificationArgsBuilder internal constructor() {
    private var configuration: Output<SubscriberNotificationConfigurationArgs>? = null

    private var subscriberId: Output<String>? = null

    /**
     * @param value Specify the configuration using which you want to create the subscriber notification..
     */
    @JvmName("fxlegvinkmsrswhi")
    public suspend fun configuration(`value`: Output<SubscriberNotificationConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value The subscriber ID for the notification subscription.
     */
    @JvmName("eugmxlqjlbpioksu")
    public suspend fun subscriberId(`value`: Output<String>) {
        this.subscriberId = value
    }

    /**
     * @param value Specify the configuration using which you want to create the subscriber notification..
     */
    @JvmName("hlxlmdemifdqxnix")
    public suspend fun configuration(`value`: SubscriberNotificationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Specify the configuration using which you want to create the subscriber notification..
     */
    @JvmName("adrfnoxhrvamnhuf")
    public suspend fun configuration(argument: suspend SubscriberNotificationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriberNotificationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The subscriber ID for the notification subscription.
     */
    @JvmName("qwsqofbdrwyqkmus")
    public suspend fun subscriberId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriberId = mapped
    }

    internal fun build(): SubscriberNotificationArgs = SubscriberNotificationArgs(
        configuration = configuration,
        subscriberId = subscriberId,
    )
}
