@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.AwsLogSourceSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accounts Specify the AWS account information where you want to enable Security Lake.
 * If not specified, uses all accounts included in the Security Lake.
 * @property regions Specify the Regions where you want to enable Security Lake.
 * @property sourceName The name for a AWS source. This must be a Regionally unique value. Valid values: `ROUTE53`, `VPC_FLOW`, `SH_FINDINGS`, `CLOUD_TRAIL_MGMT`, `LAMBDA_EXECUTION`, `S3_DATA`.
 * @property sourceVersion The version for a AWS source.
 * If not specified, the version will be the default.
 * This must be a Regionally unique value.
 */
public data class AwsLogSourceSourceArgs(
    public val accounts: Output<List<String>>? = null,
    public val regions: Output<List<String>>,
    public val sourceName: Output<String>,
    public val sourceVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.AwsLogSourceSourceArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.AwsLogSourceSourceArgs =
        com.pulumi.aws.securitylake.inputs.AwsLogSourceSourceArgs.builder()
            .accounts(accounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .regions(regions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceName(sourceName.applyValue({ args0 -> args0 }))
            .sourceVersion(sourceVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AwsLogSourceSourceArgs].
 */
@PulumiTagMarker
public class AwsLogSourceSourceArgsBuilder internal constructor() {
    private var accounts: Output<List<String>>? = null

    private var regions: Output<List<String>>? = null

    private var sourceName: Output<String>? = null

    private var sourceVersion: Output<String>? = null

    /**
     * @param value Specify the AWS account information where you want to enable Security Lake.
     * If not specified, uses all accounts included in the Security Lake.
     */
    @JvmName("gisvwgotqhwusrdk")
    public suspend fun accounts(`value`: Output<List<String>>) {
        this.accounts = value
    }

    @JvmName("gtwytajpppeklrpy")
    public suspend fun accounts(vararg values: Output<String>) {
        this.accounts = Output.all(values.asList())
    }

    /**
     * @param values Specify the AWS account information where you want to enable Security Lake.
     * If not specified, uses all accounts included in the Security Lake.
     */
    @JvmName("krqudokstacyxhrd")
    public suspend fun accounts(values: List<Output<String>>) {
        this.accounts = Output.all(values)
    }

    /**
     * @param value Specify the Regions where you want to enable Security Lake.
     */
    @JvmName("hxvcvlwakhiufygu")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("empskqpswhjkmdqg")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values Specify the Regions where you want to enable Security Lake.
     */
    @JvmName("jqspdqmvhycojpgq")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value The name for a AWS source. This must be a Regionally unique value. Valid values: `ROUTE53`, `VPC_FLOW`, `SH_FINDINGS`, `CLOUD_TRAIL_MGMT`, `LAMBDA_EXECUTION`, `S3_DATA`.
     */
    @JvmName("kiisakyhsmefwbrl")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value The version for a AWS source.
     * If not specified, the version will be the default.
     * This must be a Regionally unique value.
     */
    @JvmName("rmcbgmitysokinbn")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value Specify the AWS account information where you want to enable Security Lake.
     * If not specified, uses all accounts included in the Security Lake.
     */
    @JvmName("ewdkeaijfnxrsytw")
    public suspend fun accounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param values Specify the AWS account information where you want to enable Security Lake.
     * If not specified, uses all accounts included in the Security Lake.
     */
    @JvmName("fxcsrolpdknwouoc")
    public suspend fun accounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param value Specify the Regions where you want to enable Security Lake.
     */
    @JvmName("ifwnlrilrbtuixaj")
    public suspend fun regions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values Specify the Regions where you want to enable Security Lake.
     */
    @JvmName("mukjdsnugmqrqqrv")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value The name for a AWS source. This must be a Regionally unique value. Valid values: `ROUTE53`, `VPC_FLOW`, `SH_FINDINGS`, `CLOUD_TRAIL_MGMT`, `LAMBDA_EXECUTION`, `S3_DATA`.
     */
    @JvmName("nsrsxopibvkgireg")
    public suspend fun sourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value The version for a AWS source.
     * If not specified, the version will be the default.
     * This must be a Regionally unique value.
     */
    @JvmName("mmsphynwvmvqpqvx")
    public suspend fun sourceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    internal fun build(): AwsLogSourceSourceArgs = AwsLogSourceSourceArgs(
        accounts = accounts,
        regions = regions ?: throw PulumiNullFieldException("regions"),
        sourceName = sourceName ?: throw PulumiNullFieldException("sourceName"),
        sourceVersion = sourceVersion,
    )
}
