@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property crawlerConfiguration The configuration for the Glue Crawler for the third-party custom source.
 * @property providerIdentity The identity of the log provider for the third-party custom source.
 */
public data class CustomLogSourceConfigurationArgs(
    public val crawlerConfiguration: Output<CustomLogSourceConfigurationCrawlerConfigurationArgs>? =
        null,
    public val providerIdentity: Output<CustomLogSourceConfigurationProviderIdentityArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationArgs =
        com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationArgs.builder()
            .crawlerConfiguration(
                crawlerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .providerIdentity(
                providerIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomLogSourceConfigurationArgs].
 */
@PulumiTagMarker
public class CustomLogSourceConfigurationArgsBuilder internal constructor() {
    private var crawlerConfiguration: Output<CustomLogSourceConfigurationCrawlerConfigurationArgs>? =
        null

    private var providerIdentity: Output<CustomLogSourceConfigurationProviderIdentityArgs>? = null

    /**
     * @param value The configuration for the Glue Crawler for the third-party custom source.
     */
    @JvmName("crwjaophvtahfaur")
    public suspend fun crawlerConfiguration(`value`: Output<CustomLogSourceConfigurationCrawlerConfigurationArgs>) {
        this.crawlerConfiguration = value
    }

    /**
     * @param value The identity of the log provider for the third-party custom source.
     */
    @JvmName("hisahklxikvssxyq")
    public suspend fun providerIdentity(`value`: Output<CustomLogSourceConfigurationProviderIdentityArgs>) {
        this.providerIdentity = value
    }

    /**
     * @param value The configuration for the Glue Crawler for the third-party custom source.
     */
    @JvmName("laiwssdbgpgaomec")
    public suspend fun crawlerConfiguration(`value`: CustomLogSourceConfigurationCrawlerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crawlerConfiguration = mapped
    }

    /**
     * @param argument The configuration for the Glue Crawler for the third-party custom source.
     */
    @JvmName("entwhpfljqamrein")
    public suspend fun crawlerConfiguration(argument: suspend CustomLogSourceConfigurationCrawlerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLogSourceConfigurationCrawlerConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.crawlerConfiguration = mapped
    }

    /**
     * @param value The identity of the log provider for the third-party custom source.
     */
    @JvmName("nogvmjlsdbluutoa")
    public suspend fun providerIdentity(`value`: CustomLogSourceConfigurationProviderIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerIdentity = mapped
    }

    /**
     * @param argument The identity of the log provider for the third-party custom source.
     */
    @JvmName("xuswpwsfdrhoircy")
    public suspend fun providerIdentity(argument: suspend CustomLogSourceConfigurationProviderIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLogSourceConfigurationProviderIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.providerIdentity = mapped
    }

    internal fun build(): CustomLogSourceConfigurationArgs = CustomLogSourceConfigurationArgs(
        crawlerConfiguration = crawlerConfiguration,
        providerIdentity = providerIdentity,
    )
}
