@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
 */
public data class CustomLogSourceConfigurationCrawlerConfigurationArgs(
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs =
        com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs.builder()
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLogSourceConfigurationCrawlerConfigurationArgs].
 */
@PulumiTagMarker
public class CustomLogSourceConfigurationCrawlerConfigurationArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
     */
    @JvmName("tmbsvmxdrcoktrvg")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
     */
    @JvmName("cutxweeatmvopanr")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): CustomLogSourceConfigurationCrawlerConfigurationArgs =
        CustomLogSourceConfigurationCrawlerConfigurationArgs(
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
