@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationProviderIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalId The external ID used to estalish trust relationship with the AWS identity.
 * @property principal The AWS identity principal.
 */
public data class CustomLogSourceConfigurationProviderIdentityArgs(
    public val externalId: Output<String>,
    public val principal: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationProviderIdentityArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationProviderIdentityArgs =
        com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationProviderIdentityArgs.builder()
            .externalId(externalId.applyValue({ args0 -> args0 }))
            .principal(principal.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLogSourceConfigurationProviderIdentityArgs].
 */
@PulumiTagMarker
public class CustomLogSourceConfigurationProviderIdentityArgsBuilder internal constructor() {
    private var externalId: Output<String>? = null

    private var principal: Output<String>? = null

    /**
     * @param value The external ID used to estalish trust relationship with the AWS identity.
     */
    @JvmName("cdssooafbaxhjgnu")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value The AWS identity principal.
     */
    @JvmName("tgpgkracjernkllp")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value The external ID used to estalish trust relationship with the AWS identity.
     */
    @JvmName("lvvrfwqhmblonwul")
    public suspend fun externalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value The AWS identity principal.
     */
    @JvmName("pwnaibxdndhmpqts")
    public suspend fun principal(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): CustomLogSourceConfigurationProviderIdentityArgs =
        CustomLogSourceConfigurationProviderIdentityArgs(
            externalId = externalId ?: throw PulumiNullFieldException("externalId"),
            principal = principal ?: throw PulumiNullFieldException("principal"),
        )
}
