@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionConfigurations Provides encryption details of Amazon Security Lake object.
 * @property lifecycleConfiguration Provides lifecycle details of Amazon Security Lake object.
 * @property region The AWS Regions where Security Lake is automatically enabled.
 * @property replicationConfiguration Provides replication details of Amazon Security Lake object.
 */
public data class DataLakeConfigurationArgs(
    public val encryptionConfigurations: Output<List<DataLakeConfigurationEncryptionConfigurationArgs>>? = null,
    public val lifecycleConfiguration: Output<DataLakeConfigurationLifecycleConfigurationArgs>? =
        null,
    public val region: Output<String>,
    public val replicationConfiguration: Output<DataLakeConfigurationReplicationConfigurationArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs =
        com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs.builder()
            .encryptionConfigurations(
                encryptionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .lifecycleConfiguration(
                lifecycleConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .region(region.applyValue({ args0 -> args0 }))
            .replicationConfiguration(
                replicationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataLakeConfigurationArgs].
 */
@PulumiTagMarker
public class DataLakeConfigurationArgsBuilder internal constructor() {
    private var encryptionConfigurations:
        Output<List<DataLakeConfigurationEncryptionConfigurationArgs>>? = null

    private var lifecycleConfiguration: Output<DataLakeConfigurationLifecycleConfigurationArgs>? =
        null

    private var region: Output<String>? = null

    private var replicationConfiguration: Output<DataLakeConfigurationReplicationConfigurationArgs>? =
        null

    /**
     * @param value Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("loamplkhbcvvtowm")
    public suspend fun encryptionConfigurations(`value`: Output<List<DataLakeConfigurationEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = value
    }

    @JvmName("vlabdqwsufmdnvbb")
    public suspend fun encryptionConfigurations(vararg values: Output<DataLakeConfigurationEncryptionConfigurationArgs>) {
        this.encryptionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("isrulopvpppaardk")
    public suspend fun encryptionConfigurations(values: List<Output<DataLakeConfigurationEncryptionConfigurationArgs>>) {
        this.encryptionConfigurations = Output.all(values)
    }

    /**
     * @param value Provides lifecycle details of Amazon Security Lake object.
     */
    @JvmName("tbxbrdnvxctmjtob")
    public suspend fun lifecycleConfiguration(`value`: Output<DataLakeConfigurationLifecycleConfigurationArgs>) {
        this.lifecycleConfiguration = value
    }

    /**
     * @param value The AWS Regions where Security Lake is automatically enabled.
     */
    @JvmName("dasrrgytftgootyl")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Provides replication details of Amazon Security Lake object.
     */
    @JvmName("tjgltrdsjkqohoyr")
    public suspend fun replicationConfiguration(`value`: Output<DataLakeConfigurationReplicationConfigurationArgs>) {
        this.replicationConfiguration = value
    }

    /**
     * @param value Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("batcqlruhonyaaed")
    public suspend fun encryptionConfigurations(`value`: List<DataLakeConfigurationEncryptionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("ebnajrxstkmeyuvn")
    public suspend fun encryptionConfigurations(argument: List<suspend DataLakeConfigurationEncryptionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataLakeConfigurationEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("rakcguejcxmesvde")
    public suspend fun encryptionConfigurations(vararg argument: suspend DataLakeConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataLakeConfigurationEncryptionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param argument Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("eeieyaujkngubktv")
    public suspend fun encryptionConfigurations(argument: suspend DataLakeConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataLakeConfigurationEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.encryptionConfigurations = mapped
    }

    /**
     * @param values Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("leefcpvoyvublngs")
    public suspend fun encryptionConfigurations(vararg values: DataLakeConfigurationEncryptionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionConfigurations = mapped
    }

    /**
     * @param value Provides lifecycle details of Amazon Security Lake object.
     */
    @JvmName("ncmmiqskehseluuy")
    public suspend fun lifecycleConfiguration(`value`: DataLakeConfigurationLifecycleConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfiguration = mapped
    }

    /**
     * @param argument Provides lifecycle details of Amazon Security Lake object.
     */
    @JvmName("aakwlgmaldqdckch")
    public suspend fun lifecycleConfiguration(argument: suspend DataLakeConfigurationLifecycleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeConfigurationLifecycleConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lifecycleConfiguration = mapped
    }

    /**
     * @param value The AWS Regions where Security Lake is automatically enabled.
     */
    @JvmName("cmaqbprowvharskb")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Provides replication details of Amazon Security Lake object.
     */
    @JvmName("gmhvitfslomjcrma")
    public suspend fun replicationConfiguration(`value`: DataLakeConfigurationReplicationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationConfiguration = mapped
    }

    /**
     * @param argument Provides replication details of Amazon Security Lake object.
     */
    @JvmName("vuifctoqpfekrtsv")
    public suspend fun replicationConfiguration(argument: suspend DataLakeConfigurationReplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeConfigurationReplicationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.replicationConfiguration = mapped
    }

    internal fun build(): DataLakeConfigurationArgs = DataLakeConfigurationArgs(
        encryptionConfigurations = encryptionConfigurations,
        lifecycleConfiguration = lifecycleConfiguration,
        region = region ?: throw PulumiNullFieldException("region"),
        replicationConfiguration = replicationConfiguration,
    )
}
