@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
 */
public data class DataLakeConfigurationEncryptionConfigurationArgs(
    public val kmsKeyId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.DataLakeConfigurationEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.DataLakeConfigurationEncryptionConfigurationArgs =
        com.pulumi.aws.securitylake.inputs.DataLakeConfigurationEncryptionConfigurationArgs.builder()
            .kmsKeyId(kmsKeyId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeConfigurationEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class DataLakeConfigurationEncryptionConfigurationArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    /**
     * @param value The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
     */
    @JvmName("udytmtrnlgqweoyb")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
     */
    @JvmName("chxnyjlirxbcsoly")
    public suspend fun kmsKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): DataLakeConfigurationEncryptionConfigurationArgs =
        DataLakeConfigurationEncryptionConfigurationArgs(
            kmsKeyId = kmsKeyId ?: throw PulumiNullFieldException("kmsKeyId"),
        )
}
