@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property expiration Provides data expiration details of Amazon Security Lake object.
 * @property transitions Provides data storage transition details of Amazon Security Lake object.
 */
public data class DataLakeConfigurationLifecycleConfigurationArgs(
    public val expiration: Output<DataLakeConfigurationLifecycleConfigurationExpirationArgs>? = null,
    public val transitions: Output<List<DataLakeConfigurationLifecycleConfigurationTransitionArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationArgs =
        com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationArgs.builder()
            .expiration(expiration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .transitions(
                transitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataLakeConfigurationLifecycleConfigurationArgs].
 */
@PulumiTagMarker
public class DataLakeConfigurationLifecycleConfigurationArgsBuilder internal constructor() {
    private var expiration: Output<DataLakeConfigurationLifecycleConfigurationExpirationArgs>? = null

    private var transitions: Output<List<DataLakeConfigurationLifecycleConfigurationTransitionArgs>>? =
        null

    /**
     * @param value Provides data expiration details of Amazon Security Lake object.
     */
    @JvmName("pmqydadmvnypuyyb")
    public suspend fun expiration(`value`: Output<DataLakeConfigurationLifecycleConfigurationExpirationArgs>) {
        this.expiration = value
    }

    /**
     * @param value Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("nhfgjdnyotiwyobp")
    public suspend fun transitions(`value`: Output<List<DataLakeConfigurationLifecycleConfigurationTransitionArgs>>) {
        this.transitions = value
    }

    @JvmName("mnsnhqymgcnymanc")
    public suspend fun transitions(vararg values: Output<DataLakeConfigurationLifecycleConfigurationTransitionArgs>) {
        this.transitions = Output.all(values.asList())
    }

    /**
     * @param values Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("ohgossixkplxpqrw")
    public suspend fun transitions(values: List<Output<DataLakeConfigurationLifecycleConfigurationTransitionArgs>>) {
        this.transitions = Output.all(values)
    }

    /**
     * @param value Provides data expiration details of Amazon Security Lake object.
     */
    @JvmName("twpfeofkvjhdyvcb")
    public suspend fun expiration(`value`: DataLakeConfigurationLifecycleConfigurationExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param argument Provides data expiration details of Amazon Security Lake object.
     */
    @JvmName("ysnhgpibcdxhjbdr")
    public suspend fun expiration(argument: suspend DataLakeConfigurationLifecycleConfigurationExpirationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataLakeConfigurationLifecycleConfigurationExpirationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.expiration = mapped
    }

    /**
     * @param value Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("niwfwlbmnqderkyc")
    public suspend fun transitions(`value`: List<DataLakeConfigurationLifecycleConfigurationTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    /**
     * @param argument Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("calpmyixafedkkom")
    public suspend fun transitions(argument: List<suspend DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("iexkbijlcwwhkvsh")
    public suspend fun transitions(vararg argument: suspend DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("mgnlcpxqylyqnxkj")
    public suspend fun transitions(argument: suspend DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param values Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("vvktrgbcpnexgmyn")
    public suspend fun transitions(vararg values: DataLakeConfigurationLifecycleConfigurationTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    internal fun build(): DataLakeConfigurationLifecycleConfigurationArgs =
        DataLakeConfigurationLifecycleConfigurationArgs(
            expiration = expiration,
            transitions = transitions,
        )
}
