@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
 */
public data class DataLakeConfigurationLifecycleConfigurationExpirationArgs(
    public val days: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs =
        com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs.builder()
            .days(days?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeConfigurationLifecycleConfigurationExpirationArgs].
 */
@PulumiTagMarker
public class DataLakeConfigurationLifecycleConfigurationExpirationArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    /**
     * @param value Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
     */
    @JvmName("kbiibawuxgtikdws")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
     */
    @JvmName("jlwhjtxajcadchwa")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    internal fun build(): DataLakeConfigurationLifecycleConfigurationExpirationArgs =
        DataLakeConfigurationLifecycleConfigurationExpirationArgs(
            days = days,
        )
}
