@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
 * @property storageClass The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
 */
public data class DataLakeConfigurationLifecycleConfigurationTransitionArgs(
    public val days: Output<Int>? = null,
    public val storageClass: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs =
        com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs.builder()
            .days(days?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeConfigurationLifecycleConfigurationTransitionArgs].
 */
@PulumiTagMarker
public class DataLakeConfigurationLifecycleConfigurationTransitionArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
     */
    @JvmName("uohebibqqrkkdfno")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
     */
    @JvmName("cdrhhwvthwpdmatd")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
     */
    @JvmName("vrxllahfjdjcmdne")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
     */
    @JvmName("eouardgjlbdecjsk")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): DataLakeConfigurationLifecycleConfigurationTransitionArgs =
        DataLakeConfigurationLifecycleConfigurationTransitionArgs(
            days = days,
            storageClass = storageClass,
        )
}
