@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property httpsNotificationConfiguration The configurations for HTTPS subscriber notification.
 * @property sqsNotificationConfiguration The configurations for SQS subscriber notification.
 * There are no parameters within `sqs_notification_configuration`.
 */
public data class SubscriberNotificationConfigurationArgs(
    public val httpsNotificationConfiguration: Output<SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs>? = null,
    public val sqsNotificationConfiguration: Output<SubscriberNotificationConfigurationSqsNotificationConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs = com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationArgs.builder()
        .httpsNotificationConfiguration(
            httpsNotificationConfiguration?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .sqsNotificationConfiguration(
            sqsNotificationConfiguration?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        ).build()
}

/**
 * Builder for [SubscriberNotificationConfigurationArgs].
 */
@PulumiTagMarker
public class SubscriberNotificationConfigurationArgsBuilder internal constructor() {
    private var httpsNotificationConfiguration:
        Output<SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs>? = null

    private var sqsNotificationConfiguration:
        Output<SubscriberNotificationConfigurationSqsNotificationConfigurationArgs>? = null

    /**
     * @param value The configurations for HTTPS subscriber notification.
     */
    @JvmName("hotgfhvkghohixrg")
    public suspend fun httpsNotificationConfiguration(`value`: Output<SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs>) {
        this.httpsNotificationConfiguration = value
    }

    /**
     * @param value The configurations for SQS subscriber notification.
     * There are no parameters within `sqs_notification_configuration`.
     */
    @JvmName("wqqtwdpcopbfftvu")
    public suspend fun sqsNotificationConfiguration(`value`: Output<SubscriberNotificationConfigurationSqsNotificationConfigurationArgs>) {
        this.sqsNotificationConfiguration = value
    }

    /**
     * @param value The configurations for HTTPS subscriber notification.
     */
    @JvmName("etjwhfyaxrrhukyv")
    public suspend fun httpsNotificationConfiguration(`value`: SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsNotificationConfiguration = mapped
    }

    /**
     * @param argument The configurations for HTTPS subscriber notification.
     */
    @JvmName("euvteaplrmprakyu")
    public suspend fun httpsNotificationConfiguration(argument: suspend SubscriberNotificationConfigurationHttpsNotificationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            SubscriberNotificationConfigurationHttpsNotificationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.httpsNotificationConfiguration = mapped
    }

    /**
     * @param value The configurations for SQS subscriber notification.
     * There are no parameters within `sqs_notification_configuration`.
     */
    @JvmName("wbrnfcsjlsxuotny")
    public suspend fun sqsNotificationConfiguration(`value`: SubscriberNotificationConfigurationSqsNotificationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsNotificationConfiguration = mapped
    }

    /**
     * @param argument The configurations for SQS subscriber notification.
     * There are no parameters within `sqs_notification_configuration`.
     */
    @JvmName("qcuawxkdlnnnkyjs")
    public suspend fun sqsNotificationConfiguration(argument: suspend SubscriberNotificationConfigurationSqsNotificationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            SubscriberNotificationConfigurationSqsNotificationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sqsNotificationConfiguration = mapped
    }

    internal fun build(): SubscriberNotificationConfigurationArgs =
        SubscriberNotificationConfigurationArgs(
            httpsNotificationConfiguration = httpsNotificationConfiguration,
            sqsNotificationConfiguration = sqsNotificationConfiguration,
        )
}
