@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationApiKeyName The API key name for the notification subscription.
 * @property authorizationApiKeyValue The API key value for the notification subscription.
 * @property endpoint The subscription endpoint in Security Lake.
 * If you prefer notification with an HTTPS endpoint, populate this field.
 * @property httpMethod The HTTP method used for the notification subscription.
 * Valid values are `POST` and `PUT`.
 * @property targetRoleArn The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
 * For more information about ARNs and how to use them in policies, see Managing data access and AWS Managed Policies in the Amazon Security Lake User Guide.
 */
public data class SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs(
    public val authorizationApiKeyName: Output<String>? = null,
    public val authorizationApiKeyValue: Output<String>? = null,
    public val endpoint: Output<String>,
    public val httpMethod: Output<String>? = null,
    public val targetRoleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs =
        com.pulumi.aws.securitylake.inputs.SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs.builder()
            .authorizationApiKeyName(authorizationApiKeyName?.applyValue({ args0 -> args0 }))
            .authorizationApiKeyValue(authorizationApiKeyValue?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0 }))
            .targetRoleArn(targetRoleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs].
 */
@PulumiTagMarker
public class SubscriberNotificationConfigurationHttpsNotificationConfigurationArgsBuilder internal constructor() {
    private var authorizationApiKeyName: Output<String>? = null

    private var authorizationApiKeyValue: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var httpMethod: Output<String>? = null

    private var targetRoleArn: Output<String>? = null

    /**
     * @param value The API key name for the notification subscription.
     */
    @JvmName("odkhygamgcutfvnw")
    public suspend fun authorizationApiKeyName(`value`: Output<String>) {
        this.authorizationApiKeyName = value
    }

    /**
     * @param value The API key value for the notification subscription.
     */
    @JvmName("oukqggafmebkfvyl")
    public suspend fun authorizationApiKeyValue(`value`: Output<String>) {
        this.authorizationApiKeyValue = value
    }

    /**
     * @param value The subscription endpoint in Security Lake.
     * If you prefer notification with an HTTPS endpoint, populate this field.
     */
    @JvmName("dgtxevtccdxunatk")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The HTTP method used for the notification subscription.
     * Valid values are `POST` and `PUT`.
     */
    @JvmName("auwkeccjdmysoook")
    public suspend fun httpMethod(`value`: Output<String>) {
        this.httpMethod = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
     * For more information about ARNs and how to use them in policies, see Managing data access and AWS Managed Policies in the Amazon Security Lake User Guide.
     */
    @JvmName("rogfqlgbqhfppqix")
    public suspend fun targetRoleArn(`value`: Output<String>) {
        this.targetRoleArn = value
    }

    /**
     * @param value The API key name for the notification subscription.
     */
    @JvmName("dtmmbavumhlegbla")
    public suspend fun authorizationApiKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationApiKeyName = mapped
    }

    /**
     * @param value The API key value for the notification subscription.
     */
    @JvmName("djsrktooyghdtosw")
    public suspend fun authorizationApiKeyValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationApiKeyValue = mapped
    }

    /**
     * @param value The subscription endpoint in Security Lake.
     * If you prefer notification with an HTTPS endpoint, populate this field.
     */
    @JvmName("fgrtomacrhbjaomv")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The HTTP method used for the notification subscription.
     * Valid values are `POST` and `PUT`.
     */
    @JvmName("ifkvyegksmvkqsie")
    public suspend fun httpMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
     * For more information about ARNs and how to use them in policies, see Managing data access and AWS Managed Policies in the Amazon Security Lake User Guide.
     */
    @JvmName("llmevjqstgfimuqs")
    public suspend fun targetRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRoleArn = mapped
    }

    internal fun build(): SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs =
        SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs(
            authorizationApiKeyName = authorizationApiKeyName,
            authorizationApiKeyValue = authorizationApiKeyValue,
            endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
            httpMethod = httpMethod,
            targetRoleArn = targetRoleArn ?: throw PulumiNullFieldException("targetRoleArn"),
        )
}
