@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property awsLogSourceResource Amazon Security Lake supports log and event collection for natively supported AWS services. See `aws_log_source_resource` Block below.
 * @property customLogSourceResource Amazon Security Lake supports custom source types. See `custom_log_source_resource` Block below.
 */
public data class SubscriberSourceArgs(
    public val awsLogSourceResource: Output<SubscriberSourceAwsLogSourceResourceArgs>? = null,
    public val customLogSourceResource: Output<SubscriberSourceCustomLogSourceResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberSourceArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberSourceArgs =
        com.pulumi.aws.securitylake.inputs.SubscriberSourceArgs.builder()
            .awsLogSourceResource(
                awsLogSourceResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customLogSourceResource(
                customLogSourceResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SubscriberSourceArgs].
 */
@PulumiTagMarker
public class SubscriberSourceArgsBuilder internal constructor() {
    private var awsLogSourceResource: Output<SubscriberSourceAwsLogSourceResourceArgs>? = null

    private var customLogSourceResource: Output<SubscriberSourceCustomLogSourceResourceArgs>? = null

    /**
     * @param value Amazon Security Lake supports log and event collection for natively supported AWS services. See `aws_log_source_resource` Block below.
     */
    @JvmName("caafbkbnwxuiclcq")
    public suspend fun awsLogSourceResource(`value`: Output<SubscriberSourceAwsLogSourceResourceArgs>) {
        this.awsLogSourceResource = value
    }

    /**
     * @param value Amazon Security Lake supports custom source types. See `custom_log_source_resource` Block below.
     */
    @JvmName("mylaptncxedpoosb")
    public suspend fun customLogSourceResource(`value`: Output<SubscriberSourceCustomLogSourceResourceArgs>) {
        this.customLogSourceResource = value
    }

    /**
     * @param value Amazon Security Lake supports log and event collection for natively supported AWS services. See `aws_log_source_resource` Block below.
     */
    @JvmName("fenpdndxutajumuh")
    public suspend fun awsLogSourceResource(`value`: SubscriberSourceAwsLogSourceResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsLogSourceResource = mapped
    }

    /**
     * @param argument Amazon Security Lake supports log and event collection for natively supported AWS services. See `aws_log_source_resource` Block below.
     */
    @JvmName("knnelawcndvhtagc")
    public suspend fun awsLogSourceResource(argument: suspend SubscriberSourceAwsLogSourceResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriberSourceAwsLogSourceResourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.awsLogSourceResource = mapped
    }

    /**
     * @param value Amazon Security Lake supports custom source types. See `custom_log_source_resource` Block below.
     */
    @JvmName("ieqwmsgvuopkchuw")
    public suspend fun customLogSourceResource(`value`: SubscriberSourceCustomLogSourceResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLogSourceResource = mapped
    }

    /**
     * @param argument Amazon Security Lake supports custom source types. See `custom_log_source_resource` Block below.
     */
    @JvmName("teyjfbjmkgvoswur")
    public suspend fun customLogSourceResource(argument: suspend SubscriberSourceCustomLogSourceResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriberSourceCustomLogSourceResourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customLogSourceResource = mapped
    }

    internal fun build(): SubscriberSourceArgs = SubscriberSourceArgs(
        awsLogSourceResource = awsLogSourceResource,
        customLogSourceResource = customLogSourceResource,
    )
}
