@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberSourceAwsLogSourceResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sourceName Provides data expiration details of Amazon Security Lake object.
 * @property sourceVersion Provides data storage transition details of Amazon Security Lake object.
 */
public data class SubscriberSourceAwsLogSourceResourceArgs(
    public val sourceName: Output<String>,
    public val sourceVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberSourceAwsLogSourceResourceArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberSourceAwsLogSourceResourceArgs = com.pulumi.aws.securitylake.inputs.SubscriberSourceAwsLogSourceResourceArgs.builder()
        .sourceName(sourceName.applyValue({ args0 -> args0 }))
        .sourceVersion(sourceVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberSourceAwsLogSourceResourceArgs].
 */
@PulumiTagMarker
public class SubscriberSourceAwsLogSourceResourceArgsBuilder internal constructor() {
    private var sourceName: Output<String>? = null

    private var sourceVersion: Output<String>? = null

    /**
     * @param value Provides data expiration details of Amazon Security Lake object.
     */
    @JvmName("narrmthmpsqcjdiw")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("mouiyhauljxbytpt")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value Provides data expiration details of Amazon Security Lake object.
     */
    @JvmName("fmejdycmviuroqoh")
    public suspend fun sourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value Provides data storage transition details of Amazon Security Lake object.
     */
    @JvmName("gkgkcntadanvjdgs")
    public suspend fun sourceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    internal fun build(): SubscriberSourceAwsLogSourceResourceArgs =
        SubscriberSourceAwsLogSourceResourceArgs(
            sourceName = sourceName ?: throw PulumiNullFieldException("sourceName"),
            sourceVersion = sourceVersion,
        )
}
