@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attributes The attributes of the third-party custom source. See `attributes` Block below.
 * @property providers The details of the log provider for the third-party custom source. See `provider` Block below.
 * @property sourceName The name for a third-party custom source. This must be a Regionally unique value.
 * @property sourceVersion The version for a third-party custom source. This must be a Regionally unique value.
 */
public data class SubscriberSourceCustomLogSourceResourceArgs(
    public val attributes: Output<List<SubscriberSourceCustomLogSourceResourceAttributeArgs>>? = null,
    public val providers: Output<List<SubscriberSourceCustomLogSourceResourceProviderArgs>>? = null,
    public val sourceName: Output<String>,
    public val sourceVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceArgs =
        com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .providers(
                providers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceName(sourceName.applyValue({ args0 -> args0 }))
            .sourceVersion(sourceVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberSourceCustomLogSourceResourceArgs].
 */
@PulumiTagMarker
public class SubscriberSourceCustomLogSourceResourceArgsBuilder internal constructor() {
    private var attributes: Output<List<SubscriberSourceCustomLogSourceResourceAttributeArgs>>? = null

    private var providers: Output<List<SubscriberSourceCustomLogSourceResourceProviderArgs>>? = null

    private var sourceName: Output<String>? = null

    private var sourceVersion: Output<String>? = null

    /**
     * @param value The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("gsglynlwgxgxuygt")
    public suspend fun attributes(`value`: Output<List<SubscriberSourceCustomLogSourceResourceAttributeArgs>>) {
        this.attributes = value
    }

    @JvmName("rfwhrnhiatjmyqma")
    public suspend fun attributes(vararg values: Output<SubscriberSourceCustomLogSourceResourceAttributeArgs>) {
        this.attributes = Output.all(values.asList())
    }

    /**
     * @param values The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("puuqbdhagqejvsaj")
    public suspend fun attributes(values: List<Output<SubscriberSourceCustomLogSourceResourceAttributeArgs>>) {
        this.attributes = Output.all(values)
    }

    /**
     * @param value The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("weqqodqcybjmypbg")
    public suspend fun providers(`value`: Output<List<SubscriberSourceCustomLogSourceResourceProviderArgs>>) {
        this.providers = value
    }

    @JvmName("bvdckjcphqpntrwg")
    public suspend fun providers(vararg values: Output<SubscriberSourceCustomLogSourceResourceProviderArgs>) {
        this.providers = Output.all(values.asList())
    }

    /**
     * @param values The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("ritmbsxptmnlnutl")
    public suspend fun providers(values: List<Output<SubscriberSourceCustomLogSourceResourceProviderArgs>>) {
        this.providers = Output.all(values)
    }

    /**
     * @param value The name for a third-party custom source. This must be a Regionally unique value.
     */
    @JvmName("jxtswwsmsufgcwvx")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value The version for a third-party custom source. This must be a Regionally unique value.
     */
    @JvmName("jjmvwsjtsxxrrits")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("bwbgbguwfgqxhtyu")
    public suspend fun attributes(`value`: List<SubscriberSourceCustomLogSourceResourceAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("ftluyxasvbishnkx")
    public suspend fun attributes(argument: List<suspend SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("hqmjiehnkjgrkbib")
    public suspend fun attributes(vararg argument: suspend SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("knpwgqktxscixjec")
    public suspend fun attributes(argument: suspend SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param values The attributes of the third-party custom source. See `attributes` Block below.
     */
    @JvmName("auaytxnuiavbhfjt")
    public suspend fun attributes(vararg values: SubscriberSourceCustomLogSourceResourceAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("sedlmxmsmgadvhhh")
    public suspend fun providers(`value`: List<SubscriberSourceCustomLogSourceResourceProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param argument The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("qivcymyrncjxfvcu")
    public suspend fun providers(argument: List<suspend SubscriberSourceCustomLogSourceResourceProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriberSourceCustomLogSourceResourceProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param argument The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("tqyfoxruaplngjwe")
    public suspend fun providers(vararg argument: suspend SubscriberSourceCustomLogSourceResourceProviderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SubscriberSourceCustomLogSourceResourceProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param argument The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("ykgwyavkootgmfvv")
    public suspend fun providers(argument: suspend SubscriberSourceCustomLogSourceResourceProviderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SubscriberSourceCustomLogSourceResourceProviderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param values The details of the log provider for the third-party custom source. See `provider` Block below.
     */
    @JvmName("ddsiebmjbjojxgdk")
    public suspend fun providers(vararg values: SubscriberSourceCustomLogSourceResourceProviderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param value The name for a third-party custom source. This must be a Regionally unique value.
     */
    @JvmName("cykknkqfiiupgnls")
    public suspend fun sourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value The version for a third-party custom source. This must be a Regionally unique value.
     */
    @JvmName("ueebixhexvuceovr")
    public suspend fun sourceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    internal fun build(): SubscriberSourceCustomLogSourceResourceArgs =
        SubscriberSourceCustomLogSourceResourceArgs(
            attributes = attributes,
            providers = providers,
            sourceName = sourceName ?: throw PulumiNullFieldException("sourceName"),
            sourceVersion = sourceVersion,
        )
}
