@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crawlerArn The ARN of the AWS Glue crawler.
 * @property databaseArn The ARN of the AWS Glue database where results are written.
 * @property tableArn The ARN of the AWS Glue table.
 */
public data class SubscriberSourceCustomLogSourceResourceAttributeArgs(
    public val crawlerArn: Output<String>,
    public val databaseArn: Output<String>,
    public val tableArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceAttributeArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceAttributeArgs =
        com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceAttributeArgs.builder()
            .crawlerArn(crawlerArn.applyValue({ args0 -> args0 }))
            .databaseArn(databaseArn.applyValue({ args0 -> args0 }))
            .tableArn(tableArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberSourceCustomLogSourceResourceAttributeArgs].
 */
@PulumiTagMarker
public class SubscriberSourceCustomLogSourceResourceAttributeArgsBuilder internal constructor() {
    private var crawlerArn: Output<String>? = null

    private var databaseArn: Output<String>? = null

    private var tableArn: Output<String>? = null

    /**
     * @param value The ARN of the AWS Glue crawler.
     */
    @JvmName("xdmetletrtdyfaqi")
    public suspend fun crawlerArn(`value`: Output<String>) {
        this.crawlerArn = value
    }

    /**
     * @param value The ARN of the AWS Glue database where results are written.
     */
    @JvmName("sjgifbkgxwlabspk")
    public suspend fun databaseArn(`value`: Output<String>) {
        this.databaseArn = value
    }

    /**
     * @param value The ARN of the AWS Glue table.
     */
    @JvmName("ottjdoqbiudriksd")
    public suspend fun tableArn(`value`: Output<String>) {
        this.tableArn = value
    }

    /**
     * @param value The ARN of the AWS Glue crawler.
     */
    @JvmName("wteordkmemgswoke")
    public suspend fun crawlerArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crawlerArn = mapped
    }

    /**
     * @param value The ARN of the AWS Glue database where results are written.
     */
    @JvmName("nexvewfwfdqagxyp")
    public suspend fun databaseArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseArn = mapped
    }

    /**
     * @param value The ARN of the AWS Glue table.
     */
    @JvmName("fvdcfbokqfbbbuij")
    public suspend fun tableArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableArn = mapped
    }

    internal fun build(): SubscriberSourceCustomLogSourceResourceAttributeArgs =
        SubscriberSourceCustomLogSourceResourceAttributeArgs(
            crawlerArn = crawlerArn ?: throw PulumiNullFieldException("crawlerArn"),
            databaseArn = databaseArn ?: throw PulumiNullFieldException("databaseArn"),
            tableArn = tableArn ?: throw PulumiNullFieldException("tableArn"),
        )
}
