@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property location The location of the partition in the Amazon S3 bucket for Security Lake.
 * @property roleArn The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
 */
public data class SubscriberSourceCustomLogSourceResourceProviderArgs(
    public val location: Output<String>,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceProviderArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceProviderArgs =
        com.pulumi.aws.securitylake.inputs.SubscriberSourceCustomLogSourceResourceProviderArgs.builder()
            .location(location.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberSourceCustomLogSourceResourceProviderArgs].
 */
@PulumiTagMarker
public class SubscriberSourceCustomLogSourceResourceProviderArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The location of the partition in the Amazon S3 bucket for Security Lake.
     */
    @JvmName("nkinfnwwreurlfof")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
     */
    @JvmName("rwrtmyqlikpwypei")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The location of the partition in the Amazon S3 bucket for Security Lake.
     */
    @JvmName("mmorebvyfekbphgw")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
     */
    @JvmName("flhwppxvjxpywygo")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): SubscriberSourceCustomLogSourceResourceProviderArgs =
        SubscriberSourceCustomLogSourceResourceProviderArgs(
            location = location ?: throw PulumiNullFieldException("location"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
