@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.inputs

import com.pulumi.aws.securitylake.inputs.SubscriberSubscriberIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalId The AWS Regions where Security Lake is automatically enabled.
 * @property principal Provides encryption details of Amazon Security Lake object.
 */
public data class SubscriberSubscriberIdentityArgs(
    public val externalId: Output<String>,
    public val principal: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securitylake.inputs.SubscriberSubscriberIdentityArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.inputs.SubscriberSubscriberIdentityArgs =
        com.pulumi.aws.securitylake.inputs.SubscriberSubscriberIdentityArgs.builder()
            .externalId(externalId.applyValue({ args0 -> args0 }))
            .principal(principal.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberSubscriberIdentityArgs].
 */
@PulumiTagMarker
public class SubscriberSubscriberIdentityArgsBuilder internal constructor() {
    private var externalId: Output<String>? = null

    private var principal: Output<String>? = null

    /**
     * @param value The AWS Regions where Security Lake is automatically enabled.
     */
    @JvmName("iexhlrekthlofxnk")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("aorerkhdupnpxrcm")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value The AWS Regions where Security Lake is automatically enabled.
     */
    @JvmName("lmnyfmfmqfqkgyyv")
    public suspend fun externalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value Provides encryption details of Amazon Security Lake object.
     */
    @JvmName("piudqenjaqtceuxn")
    public suspend fun principal(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): SubscriberSubscriberIdentityArgs = SubscriberSubscriberIdentityArgs(
        externalId = externalId ?: throw PulumiNullFieldException("externalId"),
        principal = principal ?: throw PulumiNullFieldException("principal"),
    )
}
