@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accounts Specify the AWS account information where you want to enable Security Lake.
 * If not specified, uses all accounts included in the Security Lake.
 * @property regions Specify the Regions where you want to enable Security Lake.
 * @property sourceName The name for a AWS source. This must be a Regionally unique value. Valid values: `ROUTE53`, `VPC_FLOW`, `SH_FINDINGS`, `CLOUD_TRAIL_MGMT`, `LAMBDA_EXECUTION`, `S3_DATA`.
 * @property sourceVersion The version for a AWS source.
 * If not specified, the version will be the default.
 * This must be a Regionally unique value.
 */
public data class AwsLogSourceSource(
    public val accounts: List<String>? = null,
    public val regions: List<String>,
    public val sourceName: String,
    public val sourceVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.AwsLogSourceSource): AwsLogSourceSource = AwsLogSourceSource(
            accounts = javaType.accounts().map({ args0 -> args0 }),
            regions = javaType.regions().map({ args0 -> args0 }),
            sourceName = javaType.sourceName(),
            sourceVersion = javaType.sourceVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
