@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property crawlerArn The ARN of the AWS Glue crawler.
 * @property databaseArn The ARN of the AWS Glue database where results are written.
 * @property tableArn The ARN of the AWS Glue table.
 */
public data class CustomLogSourceAttribute(
    public val crawlerArn: String,
    public val databaseArn: String,
    public val tableArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.CustomLogSourceAttribute): CustomLogSourceAttribute = CustomLogSourceAttribute(
            crawlerArn = javaType.crawlerArn(),
            databaseArn = javaType.databaseArn(),
            tableArn = javaType.tableArn(),
        )
    }
}
