@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property crawlerConfiguration The configuration for the Glue Crawler for the third-party custom source.
 * @property providerIdentity The identity of the log provider for the third-party custom source.
 */
public data class CustomLogSourceConfiguration(
    public val crawlerConfiguration: CustomLogSourceConfigurationCrawlerConfiguration? = null,
    public val providerIdentity: CustomLogSourceConfigurationProviderIdentity? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.CustomLogSourceConfiguration): CustomLogSourceConfiguration = CustomLogSourceConfiguration(
            crawlerConfiguration = javaType.crawlerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceConfigurationCrawlerConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            providerIdentity = javaType.providerIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceConfigurationProviderIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
