@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property externalId The external ID used to estalish trust relationship with the AWS identity.
 * @property principal The AWS identity principal.
 */
public data class CustomLogSourceConfigurationProviderIdentity(
    public val externalId: String,
    public val principal: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.CustomLogSourceConfigurationProviderIdentity): CustomLogSourceConfigurationProviderIdentity = CustomLogSourceConfigurationProviderIdentity(
            externalId = javaType.externalId(),
            principal = javaType.principal(),
        )
    }
}
