@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property location The location of the partition in the Amazon S3 bucket for Security Lake.
 * @property roleArn The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
 */
public data class CustomLogSourceProviderDetail(
    public val location: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.CustomLogSourceProviderDetail): CustomLogSourceProviderDetail = CustomLogSourceProviderDetail(
            location = javaType.location(),
            roleArn = javaType.roleArn(),
        )
    }
}
