@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property encryptionConfigurations Provides encryption details of Amazon Security Lake object.
 * @property lifecycleConfiguration Provides lifecycle details of Amazon Security Lake object.
 * @property region The AWS Regions where Security Lake is automatically enabled.
 * @property replicationConfiguration Provides replication details of Amazon Security Lake object.
 */
public data class DataLakeConfiguration(
    public val encryptionConfigurations: List<DataLakeConfigurationEncryptionConfiguration>? = null,
    public val lifecycleConfiguration: DataLakeConfigurationLifecycleConfiguration? = null,
    public val region: String,
    public val replicationConfiguration: DataLakeConfigurationReplicationConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.DataLakeConfiguration): DataLakeConfiguration = DataLakeConfiguration(
            encryptionConfigurations = javaType.encryptionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfigurationEncryptionConfiguration.Companion.toKotlin(args0)
                })
            }),
            lifecycleConfiguration = javaType.lifecycleConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfigurationLifecycleConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            region = javaType.region(),
            replicationConfiguration = javaType.replicationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfigurationReplicationConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
