@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
 */
public data class DataLakeConfigurationEncryptionConfiguration(
    public val kmsKeyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.DataLakeConfigurationEncryptionConfiguration): DataLakeConfigurationEncryptionConfiguration = DataLakeConfigurationEncryptionConfiguration(
            kmsKeyId = javaType.kmsKeyId(),
        )
    }
}
