@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property expiration Provides data expiration details of Amazon Security Lake object.
 * @property transitions Provides data storage transition details of Amazon Security Lake object.
 */
public data class DataLakeConfigurationLifecycleConfiguration(
    public val expiration: DataLakeConfigurationLifecycleConfigurationExpiration? = null,
    public val transitions: List<DataLakeConfigurationLifecycleConfigurationTransition>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.DataLakeConfigurationLifecycleConfiguration): DataLakeConfigurationLifecycleConfiguration = DataLakeConfigurationLifecycleConfiguration(
            expiration = javaType.expiration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfigurationLifecycleConfigurationExpiration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            transitions = javaType.transitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfigurationLifecycleConfigurationTransition.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
