@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property days Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
 * @property storageClass The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
 */
public data class DataLakeConfigurationLifecycleConfigurationTransition(
    public val days: Int? = null,
    public val storageClass: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.DataLakeConfigurationLifecycleConfigurationTransition): DataLakeConfigurationLifecycleConfigurationTransition =
            DataLakeConfigurationLifecycleConfigurationTransition(
                days = javaType.days().map({ args0 -> args0 }).orElse(null),
                storageClass = javaType.storageClass().map({ args0 -> args0 }).orElse(null),
            )
    }
}
