@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property regions Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets that are configured for object replication can be owned by the same AWS account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different AWS Regions or within the same Region as the source bucket.
 * @property roleArn Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
 */
public data class DataLakeConfigurationReplicationConfiguration(
    public val regions: List<String>? = null,
    public val roleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.DataLakeConfigurationReplicationConfiguration): DataLakeConfigurationReplicationConfiguration =
            DataLakeConfigurationReplicationConfiguration(
                regions = javaType.regions().map({ args0 -> args0 }),
                roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
