@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property httpsNotificationConfiguration The configurations for HTTPS subscriber notification.
 * @property sqsNotificationConfiguration The configurations for SQS subscriber notification.
 * There are no parameters within `sqs_notification_configuration`.
 */
public data class SubscriberNotificationConfiguration(
    public val httpsNotificationConfiguration: SubscriberNotificationConfigurationHttpsNotificationConfiguration? = null,
    public val sqsNotificationConfiguration: SubscriberNotificationConfigurationSqsNotificationConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.SubscriberNotificationConfiguration): SubscriberNotificationConfiguration = SubscriberNotificationConfiguration(
            httpsNotificationConfiguration = javaType.httpsNotificationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.SubscriberNotificationConfigurationHttpsNotificationConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqsNotificationConfiguration = javaType.sqsNotificationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.SubscriberNotificationConfigurationSqsNotificationConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
