@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationApiKeyName The API key name for the notification subscription.
 * @property authorizationApiKeyValue The API key value for the notification subscription.
 * @property endpoint The subscription endpoint in Security Lake.
 * If you prefer notification with an HTTPS endpoint, populate this field.
 * @property httpMethod The HTTP method used for the notification subscription.
 * Valid values are `POST` and `PUT`.
 * @property targetRoleArn The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
 * For more information about ARNs and how to use them in policies, see Managing data access and AWS Managed Policies in the Amazon Security Lake User Guide.
 */
public data class SubscriberNotificationConfigurationHttpsNotificationConfiguration(
    public val authorizationApiKeyName: String? = null,
    public val authorizationApiKeyValue: String? = null,
    public val endpoint: String,
    public val httpMethod: String? = null,
    public val targetRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.SubscriberNotificationConfigurationHttpsNotificationConfiguration): SubscriberNotificationConfigurationHttpsNotificationConfiguration =
            SubscriberNotificationConfigurationHttpsNotificationConfiguration(
                authorizationApiKeyName = javaType.authorizationApiKeyName().map({ args0 -> args0 }).orElse(null),
                authorizationApiKeyValue = javaType.authorizationApiKeyValue().map({ args0 -> args0 }).orElse(null),
                endpoint = javaType.endpoint(),
                httpMethod = javaType.httpMethod().map({ args0 -> args0 }).orElse(null),
                targetRoleArn = javaType.targetRoleArn(),
            )
    }
}
