@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property awsLogSourceResource Amazon Security Lake supports log and event collection for natively supported AWS services. See `aws_log_source_resource` Block below.
 * @property customLogSourceResource Amazon Security Lake supports custom source types. See `custom_log_source_resource` Block below.
 */
public data class SubscriberSource(
    public val awsLogSourceResource: SubscriberSourceAwsLogSourceResource? = null,
    public val customLogSourceResource: SubscriberSourceCustomLogSourceResource? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.SubscriberSource): SubscriberSource = SubscriberSource(
            awsLogSourceResource = javaType.awsLogSourceResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSourceAwsLogSourceResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customLogSourceResource = javaType.customLogSourceResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSourceCustomLogSourceResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
