@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceName Provides data expiration details of Amazon Security Lake object.
 * @property sourceVersion Provides data storage transition details of Amazon Security Lake object.
 */
public data class SubscriberSourceAwsLogSourceResource(
    public val sourceName: String,
    public val sourceVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.SubscriberSourceAwsLogSourceResource): SubscriberSourceAwsLogSourceResource = SubscriberSourceAwsLogSourceResource(
            sourceName = javaType.sourceName(),
            sourceVersion = javaType.sourceVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
