@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attributes The attributes of the third-party custom source. See `attributes` Block below.
 * @property providers The details of the log provider for the third-party custom source. See `provider` Block below.
 * @property sourceName The name for a third-party custom source. This must be a Regionally unique value.
 * @property sourceVersion The version for a third-party custom source. This must be a Regionally unique value.
 */
public data class SubscriberSourceCustomLogSourceResource(
    public val attributes: List<SubscriberSourceCustomLogSourceResourceAttribute>? = null,
    public val providers: List<SubscriberSourceCustomLogSourceResourceProvider>? = null,
    public val sourceName: String,
    public val sourceVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.SubscriberSourceCustomLogSourceResource): SubscriberSourceCustomLogSourceResource = SubscriberSourceCustomLogSourceResource(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSourceCustomLogSourceResourceAttribute.Companion.toKotlin(args0)
                })
            }),
            providers = javaType.providers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSourceCustomLogSourceResourceProvider.Companion.toKotlin(args0)
                })
            }),
            sourceName = javaType.sourceName(),
            sourceVersion = javaType.sourceVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
