@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property externalId The AWS Regions where Security Lake is automatically enabled.
 * @property principal Provides encryption details of Amazon Security Lake object.
 */
public data class SubscriberSubscriberIdentity(
    public val externalId: String,
    public val principal: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securitylake.outputs.SubscriberSubscriberIdentity): SubscriberSubscriberIdentity = SubscriberSubscriberIdentity(
            externalId = javaType.externalId(),
            principal = javaType.principal(),
        )
    }
}
