@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin

import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deploys an Application CloudFormation Stack from the Serverless Application Repository.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getPartition({});
 * const currentGetRegion = aws.getRegion({});
 * const postgres_rotator = new aws.serverlessrepository.CloudFormationStack("postgres-rotator", {
 *     name: "postgres-rotator",
 *     applicationId: "arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser",
 *     capabilities: [
 *         "CAPABILITY_IAM",
 *         "CAPABILITY_RESOURCE_POLICY",
 *     ],
 *     parameters: {
 *         functionName: "func-postgres-rotator",
 *         endpoint: Promise.all([currentGetRegion, current])&#46;then(([currentGetRegion, current]) => `secretsmanager.${currentGetRegion.name}.${current.dnsSuffix}`),
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_partition()
 * current_get_region = aws.get_region()
 * postgres_rotator = aws.serverlessrepository.CloudFormationStack("postgres-rotator",
 *     name="postgres-rotator",
 *     application_id="arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser",
 *     capabilities=[
 *         "CAPABILITY_IAM",
 *         "CAPABILITY_RESOURCE_POLICY",
 *     ],
 *     parameters={
 *         "functionName": "func-postgres-rotator",
 *         "endpoint": f"secretsmanager.{current_get_region.name}.{current.dns_suffix}",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetPartition.Invoke();
 *     var currentGetRegion = Aws.GetRegion.Invoke();
 *     var postgres_rotator = new Aws.ServerlessRepository.CloudFormationStack("postgres-rotator", new()
 *     {
 *         Name = "postgres-rotator",
 *         ApplicationId = "arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser",
 *         Capabilities = new[]
 *         {
 *             "CAPABILITY_IAM",
 *             "CAPABILITY_RESOURCE_POLICY",
 *         },
 *         Parameters =
 *         {
 *             { "functionName", "func-postgres-rotator" },
 *             { "endpoint", Output.Tuple(currentGetRegion, current).Apply(values =>
 *             {
 *                 var currentGetRegion = values.Item1;
 *                 var current = values.Item2;
 *                 return $"secretsmanager.{currentGetRegion.Apply(getRegionResult => getRegionResult.Name)}.{current.Apply(getPartitionResult => getPartitionResult.DnsSuffix)}";
 *             }) },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/serverlessrepository"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetRegion, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = serverlessrepository.NewCloudFormationStack(ctx, "postgres-rotator", &serverlessrepository.CloudFormationStackArgs{
 * 			Name:          pulumi.String("postgres-rotator"),
 * 			ApplicationId: pulumi.String("arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser"),
 * 			Capabilities: pulumi.StringArray{
 * 				pulumi.String("CAPABILITY_IAM"),
 * 				pulumi.String("CAPABILITY_RESOURCE_POLICY"),
 * 			},
 * 			Parameters: pulumi.StringMap{
 * 				"functionName": pulumi.String("func-postgres-rotator"),
 * 				"endpoint":     pulumi.Sprintf("secretsmanager.%v.%v", currentGetRegion.Name, current.DnsSuffix),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.serverlessrepository.CloudFormationStack;
 * import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getPartition();
 *         final var currentGetRegion = AwsFunctions.getRegion();
 *         var postgres_rotator = new CloudFormationStack("postgres-rotator", CloudFormationStackArgs.builder()
 *             .name("postgres-rotator")
 *             .applicationId("arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser")
 *             .capabilities(
 *                 "CAPABILITY_IAM",
 *                 "CAPABILITY_RESOURCE_POLICY")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("functionName", "func-postgres-rotator"),
 *                 Map.entry("endpoint", String.format("secretsmanager.%s.%s", currentGetRegion.applyValue(getRegionResult -> getRegionResult.name()),current.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix())))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   postgres-rotator:
 *     type: aws:serverlessrepository:CloudFormationStack
 *     properties:
 *       name: postgres-rotator
 *       applicationId: arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser
 *       capabilities:
 *         - CAPABILITY_IAM
 *         - CAPABILITY_RESOURCE_POLICY
 *       parameters:
 *         functionName: func-postgres-rotator
 *         endpoint: secretsmanager.${currentGetRegion.name}.${current.dnsSuffix}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Serverless Application Repository Stack using the CloudFormation Stack name (with or without the `serverlessrepo-` prefix) or the CloudFormation Stack ID. For example:
 * ```sh
 * $ pulumi import aws:serverlessrepository/cloudFormationStack:CloudFormationStack example serverlessrepo-postgres-rotator
 * ```
 * @property applicationId The ARN of the application from the Serverless Application Repository.
 * @property capabilities A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
 * @property name The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
 * @property parameters A map of Parameter structures that specify input parameters for the stack.
 * @property semanticVersion The version of the application to deploy. If not supplied, deploys the latest version.
 * @property tags A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CloudFormationStackArgs(
    public val applicationId: Output<String>? = null,
    public val capabilities: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val semanticVersion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.serverlessrepository.CloudFormationStackArgs> {
    override fun toJava(): com.pulumi.aws.serverlessrepository.CloudFormationStackArgs =
        com.pulumi.aws.serverlessrepository.CloudFormationStackArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .capabilities(capabilities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .semanticVersion(semanticVersion?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CloudFormationStackArgs].
 */
@PulumiTagMarker
public class CloudFormationStackArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var capabilities: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var semanticVersion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ARN of the application from the Serverless Application Repository.
     */
    @JvmName("poxtbpbdxonjtfmh")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("niljfnsjflrqnonb")
    public suspend fun capabilities(`value`: Output<List<String>>) {
        this.capabilities = value
    }

    @JvmName("nlkkmqxghcubsirb")
    public suspend fun capabilities(vararg values: Output<String>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("cqykupgydjbeekmy")
    public suspend fun capabilities(values: List<Output<String>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
     */
    @JvmName("kscysxwekiincjtj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("ncbjejymdubbtegq")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The version of the application to deploy. If not supplied, deploys the latest version.
     */
    @JvmName("cjpfjfxhcrohjjxi")
    public suspend fun semanticVersion(`value`: Output<String>) {
        this.semanticVersion = value
    }

    /**
     * @param value A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sbpaoqkgpklpcedo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the application from the Serverless Application Repository.
     */
    @JvmName("fcveoisoraepuowa")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("sspajitchwlfdscb")
    public suspend fun capabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param values A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("lafeolceyoxijctb")
    public suspend fun capabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
     */
    @JvmName("ljjlnxbjtrpvpowc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("vqeydaytmbrrcguo")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("uisximbvrgawfxvm")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The version of the application to deploy. If not supplied, deploys the latest version.
     */
    @JvmName("eribakrnebaxehdg")
    public suspend fun semanticVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.semanticVersion = mapped
    }

    /**
     * @param value A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gleopyegfuqafahq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eiexuddhdwjdwwsr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CloudFormationStackArgs = CloudFormationStackArgs(
        applicationId = applicationId,
        capabilities = capabilities,
        name = name,
        parameters = parameters,
        semanticVersion = semanticVersion,
        tags = tags,
    )
}
