@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin

import com.pulumi.aws.serverlessrepository.ServerlessrepositoryFunctions.getApplicationPlain
import com.pulumi.aws.serverlessrepository.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.aws.serverlessrepository.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.aws.serverlessrepository.kotlin.outputs.GetApplicationResult
import com.pulumi.aws.serverlessrepository.kotlin.outputs.GetApplicationResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ServerlessrepositoryFunctions {
    /**
     * Use this data source to get information about an AWS Serverless Application Repository application. For example, this can be used to determine the required `capabilities` for an application.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.serverlessrepository.getApplication({
     *     applicationId: "arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication",
     * });
     * const exampleCloudFormationStack = new aws.serverlessrepository.CloudFormationStack("example", {
     *     name: "Example",
     *     applicationId: example.then(example => example.applicationId),
     *     semanticVersion: example.then(example => example.semanticVersion),
     *     capabilities: example.then(example => example.requiredCapabilities),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.serverlessrepository.get_application(application_id="arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication")
     * example_cloud_formation_stack = aws.serverlessrepository.CloudFormationStack("example",
     *     name="Example",
     *     application_id=example.application_id,
     *     semantic_version=example.semantic_version,
     *     capabilities=example.required_capabilities)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServerlessRepository.GetApplication.Invoke(new()
     *     {
     *         ApplicationId = "arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication",
     *     });
     *     var exampleCloudFormationStack = new Aws.ServerlessRepository.CloudFormationStack("example", new()
     *     {
     *         Name = "Example",
     *         ApplicationId = example.Apply(getApplicationResult => getApplicationResult.ApplicationId),
     *         SemanticVersion = example.Apply(getApplicationResult => getApplicationResult.SemanticVersion),
     *         Capabilities = example.Apply(getApplicationResult => getApplicationResult.RequiredCapabilities),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/serverlessrepository"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := serverlessrepository.GetApplication(ctx, &serverlessrepository.GetApplicationArgs{
     * 			ApplicationId: "arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = serverlessrepository.NewCloudFormationStack(ctx, "example", &serverlessrepository.CloudFormationStackArgs{
     * 			Name:            pulumi.String("Example"),
     * 			ApplicationId:   pulumi.String(example.ApplicationId),
     * 			SemanticVersion: pulumi.String(example.SemanticVersion),
     * 			Capabilities:    interface{}(example.RequiredCapabilities),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.serverlessrepository.ServerlessrepositoryFunctions;
     * import com.pulumi.aws.serverlessrepository.inputs.GetApplicationArgs;
     * import com.pulumi.aws.serverlessrepository.CloudFormationStack;
     * import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServerlessrepositoryFunctions.getApplication(GetApplicationArgs.builder()
     *             .applicationId("arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication")
     *             .build());
     *         var exampleCloudFormationStack = new CloudFormationStack("exampleCloudFormationStack", CloudFormationStackArgs.builder()
     *             .name("Example")
     *             .applicationId(example.applyValue(getApplicationResult -> getApplicationResult.applicationId()))
     *             .semanticVersion(example.applyValue(getApplicationResult -> getApplicationResult.semanticVersion()))
     *             .capabilities(example.applyValue(getApplicationResult -> getApplicationResult.requiredCapabilities()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   exampleCloudFormationStack:
     *     type: aws:serverlessrepository:CloudFormationStack
     *     name: example
     *     properties:
     *       name: Example
     *       applicationId: ${example.applicationId}
     *       semanticVersion: ${example.semanticVersion}
     *       capabilities: ${example.requiredCapabilities}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:serverlessrepository:getApplication
     *       Arguments:
     *         applicationId: arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplication.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        toKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationId ARN of the application.
     * @param semanticVersion Requested version of the application. By default, retrieves the latest version.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(applicationId: String, semanticVersion: String? = null): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationId = applicationId,
            semanticVersion = semanticVersion,
        )
        return toKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;serverlessrepository&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }
}
