@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AppregistryApplication].
 */
@PulumiTagMarker
public class AppregistryApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppregistryApplicationArgs = AppregistryApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppregistryApplicationArgsBuilder.() -> Unit) {
        val builder = AppregistryApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppregistryApplication {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.AppregistryApplication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppregistryApplication(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Service Catalog AppRegistry Application.
 * > An AWS Service Catalog AppRegistry Application is displayed in the AWS Console under "MyApplications".
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.AppregistryApplication("example", {name: "example-app"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.AppregistryApplication("example", new()
 *     {
 *         Name = "example-app",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewAppregistryApplication(ctx, "example", &servicecatalog.AppregistryApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.AppregistryApplication;
 * import com.pulumi.aws.servicecatalog.AppregistryApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppregistryApplication("example", AppregistryApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:AppregistryApplication
 *     properties:
 *       name: example-app
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Connecting Resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.AppregistryApplication("example", {name: "example-app"});
 * const bucket = new aws.s3.BucketV2("bucket", {
 *     bucket: "example-bucket",
 *     tags: example.applicationTag,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
 * bucket = aws.s3.BucketV2("bucket",
 *     bucket="example-bucket",
 *     tags=example.application_tag)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.AppregistryApplication("example", new()
 *     {
 *         Name = "example-app",
 *     });
 *     var bucket = new Aws.S3.BucketV2("bucket", new()
 *     {
 *         Bucket = "example-bucket",
 *         Tags = example.ApplicationTag,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := servicecatalog.NewAppregistryApplication(ctx, "example", &servicecatalog.AppregistryApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketV2(ctx, "bucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example-bucket"),
 * 			Tags:   example.ApplicationTag,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.AppregistryApplication;
 * import com.pulumi.aws.servicecatalog.AppregistryApplicationArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppregistryApplication("example", AppregistryApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *         var bucket = new BucketV2("bucket", BucketV2Args.builder()
 *             .bucket("example-bucket")
 *             .tags(example.applicationTag())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:AppregistryApplication
 *     properties:
 *       name: example-app
 *   bucket:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example-bucket
 *       tags: ${example.applicationTag}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Service Catalog AppRegistry Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/appregistryApplication:AppregistryApplication example application-id-12345678
 * ```
 */
public class AppregistryApplication internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.AppregistryApplication,
) : KotlinCustomResource(javaResource, AppregistryApplicationMapper) {
    /**
     * A map with a single tag key-value pair used to associate resources with the application. This attribute can be passed directly into the `tags` argument of another resource, or merged into a map of existing tags.
     */
    public val applicationTag: Output<Map<String, String>>
        get() = javaResource.applicationTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ARN (Amazon Resource Name) of the application.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the application. The name must be unique within an AWS region.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object AppregistryApplicationMapper : ResourceMapper<AppregistryApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.AppregistryApplication::class == javaResource::class

    override fun map(javaResource: Resource): AppregistryApplication =
        AppregistryApplication(javaResource as com.pulumi.aws.servicecatalog.AppregistryApplication)
}

/**
 * @see [AppregistryApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppregistryApplication].
 */
public suspend fun appregistryApplication(
    name: String,
    block: suspend AppregistryApplicationResourceBuilder.() -> Unit,
): AppregistryApplication {
    val builder = AppregistryApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppregistryApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appregistryApplication(name: String): AppregistryApplication {
    val builder = AppregistryApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
