@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.AppregistryApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Service Catalog AppRegistry Application.
 * > An AWS Service Catalog AppRegistry Application is displayed in the AWS Console under "MyApplications".
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.AppregistryApplication("example", {name: "example-app"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.AppregistryApplication("example", new()
 *     {
 *         Name = "example-app",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewAppregistryApplication(ctx, "example", &servicecatalog.AppregistryApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.AppregistryApplication;
 * import com.pulumi.aws.servicecatalog.AppregistryApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppregistryApplication("example", AppregistryApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:AppregistryApplication
 *     properties:
 *       name: example-app
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Connecting Resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.AppregistryApplication("example", {name: "example-app"});
 * const bucket = new aws.s3.BucketV2("bucket", {
 *     bucket: "example-bucket",
 *     tags: example.applicationTag,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
 * bucket = aws.s3.BucketV2("bucket",
 *     bucket="example-bucket",
 *     tags=example.application_tag)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.AppregistryApplication("example", new()
 *     {
 *         Name = "example-app",
 *     });
 *     var bucket = new Aws.S3.BucketV2("bucket", new()
 *     {
 *         Bucket = "example-bucket",
 *         Tags = example.ApplicationTag,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := servicecatalog.NewAppregistryApplication(ctx, "example", &servicecatalog.AppregistryApplicationArgs{
 * 			Name: pulumi.String("example-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketV2(ctx, "bucket", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example-bucket"),
 * 			Tags:   example.ApplicationTag,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.AppregistryApplication;
 * import com.pulumi.aws.servicecatalog.AppregistryApplicationArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppregistryApplication("example", AppregistryApplicationArgs.builder()
 *             .name("example-app")
 *             .build());
 *         var bucket = new BucketV2("bucket", BucketV2Args.builder()
 *             .bucket("example-bucket")
 *             .tags(example.applicationTag())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:AppregistryApplication
 *     properties:
 *       name: example-app
 *   bucket:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example-bucket
 *       tags: ${example.applicationTag}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Service Catalog AppRegistry Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/appregistryApplication:AppregistryApplication example application-id-12345678
 * ```
 * @property description Description of the application.
 * @property name Name of the application. The name must be unique within an AWS region.
 * The following arguments are optional:
 */
public data class AppregistryApplicationArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.AppregistryApplicationArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.AppregistryApplicationArgs =
        com.pulumi.aws.servicecatalog.AppregistryApplicationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppregistryApplicationArgs].
 */
@PulumiTagMarker
public class AppregistryApplicationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Description of the application.
     */
    @JvmName("mpegecbpdnvxpjou")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the application. The name must be unique within an AWS region.
     * The following arguments are optional:
     */
    @JvmName("ogasrvdmfumtexdx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("rbiafxsqafwxugqx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the application. The name must be unique within an AWS region.
     * The following arguments are optional:
     */
    @JvmName("tjnqllchluttdkra")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AppregistryApplicationArgs = AppregistryApplicationArgs(
        description = description,
        name = name,
    )
}
