@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BudgetResourceAssociation].
 */
@PulumiTagMarker
public class BudgetResourceAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetResourceAssociationArgs = BudgetResourceAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetResourceAssociationArgsBuilder.() -> Unit) {
        val builder = BudgetResourceAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BudgetResourceAssociation {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.BudgetResourceAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BudgetResourceAssociation(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Budget Resource Association.
 * > **Tip:** A "resource" is either a Service Catalog portfolio or product.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.BudgetResourceAssociation("example", {
 *     budgetName: "budget-pjtvyakdlyo3m",
 *     resourceId: "prod-dnigbtea24ste",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.BudgetResourceAssociation("example",
 *     budget_name="budget-pjtvyakdlyo3m",
 *     resource_id="prod-dnigbtea24ste")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.BudgetResourceAssociation("example", new()
 *     {
 *         BudgetName = "budget-pjtvyakdlyo3m",
 *         ResourceId = "prod-dnigbtea24ste",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewBudgetResourceAssociation(ctx, "example", &servicecatalog.BudgetResourceAssociationArgs{
 * 			BudgetName: pulumi.String("budget-pjtvyakdlyo3m"),
 * 			ResourceId: pulumi.String("prod-dnigbtea24ste"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.BudgetResourceAssociation;
 * import com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BudgetResourceAssociation("example", BudgetResourceAssociationArgs.builder()
 *             .budgetName("budget-pjtvyakdlyo3m")
 *             .resourceId("prod-dnigbtea24ste")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:BudgetResourceAssociation
 *     properties:
 *       budgetName: budget-pjtvyakdlyo3m
 *       resourceId: prod-dnigbtea24ste
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_budget_resource_association` using the budget name and resource ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/budgetResourceAssociation:BudgetResourceAssociation example budget-pjtvyakdlyo3m:prod-dnigbtea24ste
 * ```
 */
public class BudgetResourceAssociation internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.BudgetResourceAssociation,
) : KotlinCustomResource(javaResource, BudgetResourceAssociationMapper) {
    /**
     * Budget name.
     */
    public val budgetName: Output<String>
        get() = javaResource.budgetName().applyValue({ args0 -> args0 })

    /**
     * Resource identifier.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })
}

public object BudgetResourceAssociationMapper : ResourceMapper<BudgetResourceAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.BudgetResourceAssociation::class == javaResource::class

    override fun map(javaResource: Resource): BudgetResourceAssociation =
        BudgetResourceAssociation(
            javaResource as
                com.pulumi.aws.servicecatalog.BudgetResourceAssociation,
        )
}

/**
 * @see [BudgetResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BudgetResourceAssociation].
 */
public suspend fun budgetResourceAssociation(
    name: String,
    block: suspend BudgetResourceAssociationResourceBuilder.() -> Unit,
): BudgetResourceAssociation {
    val builder = BudgetResourceAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BudgetResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budgetResourceAssociation(name: String): BudgetResourceAssociation {
    val builder = BudgetResourceAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
