@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Constraint.
 * > **NOTE:** This resource does not associate a Service Catalog product and portfolio. However, the product and portfolio must be associated (see the `aws.servicecatalog.ProductPortfolioAssociation` resource) prior to creating a constraint or you will receive an error.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.Constraint("example", {
 *     description: "Back off, man. I'm a scientist.",
 *     portfolioId: exampleAwsServicecatalogPortfolio.id,
 *     productId: exampleAwsServicecatalogProduct.id,
 *     type: "LAUNCH",
 *     parameters: JSON.stringify({
 *         RoleArn: "arn:aws:iam::123456789012:role/LaunchRole",
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.servicecatalog.Constraint("example",
 *     description="Back off, man. I'm a scientist.",
 *     portfolio_id=example_aws_servicecatalog_portfolio["id"],
 *     product_id=example_aws_servicecatalog_product["id"],
 *     type="LAUNCH",
 *     parameters=json.dumps({
 *         "RoleArn": "arn:aws:iam::123456789012:role/LaunchRole",
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.Constraint("example", new()
 *     {
 *         Description = "Back off, man. I'm a scientist.",
 *         PortfolioId = exampleAwsServicecatalogPortfolio.Id,
 *         ProductId = exampleAwsServicecatalogProduct.Id,
 *         Type = "LAUNCH",
 *         Parameters = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["RoleArn"] = "arn:aws:iam::123456789012:role/LaunchRole",
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"RoleArn": "arn:aws:iam::123456789012:role/LaunchRole",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = servicecatalog.NewConstraint(ctx, "example", &servicecatalog.ConstraintArgs{
 * 			Description: pulumi.String("Back off, man. I'm a scientist."),
 * 			PortfolioId: pulumi.Any(exampleAwsServicecatalogPortfolio.Id),
 * 			ProductId:   pulumi.Any(exampleAwsServicecatalogProduct.Id),
 * 			Type:        pulumi.String("LAUNCH"),
 * 			Parameters:  pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Constraint;
 * import com.pulumi.aws.servicecatalog.ConstraintArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Constraint("example", ConstraintArgs.builder()
 *             .description("Back off, man. I'm a scientist.")
 *             .portfolioId(exampleAwsServicecatalogPortfolio.id())
 *             .productId(exampleAwsServicecatalogProduct.id())
 *             .type("LAUNCH")
 *             .parameters(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("RoleArn", "arn:aws:iam::123456789012:role/LaunchRole")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:Constraint
 *     properties:
 *       description: Back off, man. I'm a scientist.
 *       portfolioId: ${exampleAwsServicecatalogPortfolio.id}
 *       productId: ${exampleAwsServicecatalogProduct.id}
 *       type: LAUNCH
 *       parameters:
 *         fn::toJSON:
 *           RoleArn: arn:aws:iam::123456789012:role/LaunchRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_constraint` using the constraint ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/constraint:Constraint example cons-nmdkb6cgxfcrs
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property description Description of the constraint.
 * @property parameters Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
 * @property portfolioId Portfolio identifier.
 * @property productId Product identifier.
 * @property type Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
 * The following arguments are optional:
 */
public data class ConstraintArgs(
    public val acceptLanguage: Output<String>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<String>? = null,
    public val portfolioId: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ConstraintArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ConstraintArgs =
        com.pulumi.aws.servicecatalog.ConstraintArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConstraintArgs].
 */
@PulumiTagMarker
public class ConstraintArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var description: Output<String>? = null

    private var parameters: Output<String>? = null

    private var portfolioId: Output<String>? = null

    private var productId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("lmvxwsxxeqaxnwqk")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Description of the constraint.
     */
    @JvmName("nmqtapwfylebrmdy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
     */
    @JvmName("oxeprsyxsboikxvl")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("erurwcuvjbmgkdan")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Product identifier.
     */
    @JvmName("dwaiyrywlvtpghmo")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
     * The following arguments are optional:
     */
    @JvmName("gubbpreculpsvvtt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("bowmqecunvgucvhc")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Description of the constraint.
     */
    @JvmName("kojpnuibwafoktdq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
     */
    @JvmName("svucjpwhphaqholo")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("hvafrqfsqejypkli")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Product identifier.
     */
    @JvmName("juukvnwlsnkoroxb")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
     * The following arguments are optional:
     */
    @JvmName("wrkagfpjcxxswjyp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConstraintArgs = ConstraintArgs(
        acceptLanguage = acceptLanguage,
        description = description,
        parameters = parameters,
        portfolioId = portfolioId,
        productId = productId,
        type = type,
    )
}
