@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationsAccess].
 */
@PulumiTagMarker
public class OrganizationsAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationsAccessArgs = OrganizationsAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationsAccessArgsBuilder.() -> Unit) {
        val builder = OrganizationsAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationsAccess {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.OrganizationsAccess(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationsAccess(builtJavaResource)
    }
}

/**
 * Manages Service Catalog AWS Organizations Access, a portfolio sharing feature through AWS Organizations. This allows Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This resource will prompt AWS to set `organizations:EnableAWSServiceAccess` on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure.
 * > **NOTE:** This resource can only be used by the management account in the organization. In other words, a delegated administrator is not authorized to use the resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.OrganizationsAccess("example", {enabled: true});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.OrganizationsAccess("example", enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.OrganizationsAccess("example", new()
 *     {
 *         Enabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewOrganizationsAccess(ctx, "example", &servicecatalog.OrganizationsAccessArgs{
 * 			Enabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.OrganizationsAccess;
 * import com.pulumi.aws.servicecatalog.OrganizationsAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationsAccess("example", OrganizationsAccessArgs.builder()
 *             .enabled("true")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:OrganizationsAccess
 *     properties:
 *       enabled: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class OrganizationsAccess internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.OrganizationsAccess,
) : KotlinCustomResource(javaResource, OrganizationsAccessMapper) {
    /**
     * Whether to enable AWS Organizations access.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })
}

public object OrganizationsAccessMapper : ResourceMapper<OrganizationsAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.OrganizationsAccess::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationsAccess = OrganizationsAccess(
        javaResource
            as com.pulumi.aws.servicecatalog.OrganizationsAccess,
    )
}

/**
 * @see [OrganizationsAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationsAccess].
 */
public suspend fun organizationsAccess(
    name: String,
    block: suspend OrganizationsAccessResourceBuilder.() -> Unit,
): OrganizationsAccess {
    val builder = OrganizationsAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationsAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationsAccess(name: String): OrganizationsAccess {
    val builder = OrganizationsAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
