@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Portfolio].
 */
@PulumiTagMarker
public class PortfolioResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PortfolioArgs = PortfolioArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PortfolioArgsBuilder.() -> Unit) {
        val builder = PortfolioArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Portfolio {
        val builtJavaResource = com.pulumi.aws.servicecatalog.Portfolio(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Portfolio(builtJavaResource)
    }
}

/**
 * Provides a resource to create a Service Catalog Portfolio.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const portfolio = new aws.servicecatalog.Portfolio("portfolio", {
 *     name: "My App Portfolio",
 *     description: "List of my organizations apps",
 *     providerName: "Brett",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * portfolio = aws.servicecatalog.Portfolio("portfolio",
 *     name="My App Portfolio",
 *     description="List of my organizations apps",
 *     provider_name="Brett")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var portfolio = new Aws.ServiceCatalog.Portfolio("portfolio", new()
 *     {
 *         Name = "My App Portfolio",
 *         Description = "List of my organizations apps",
 *         ProviderName = "Brett",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewPortfolio(ctx, "portfolio", &servicecatalog.PortfolioArgs{
 * 			Name:         pulumi.String("My App Portfolio"),
 * 			Description:  pulumi.String("List of my organizations apps"),
 * 			ProviderName: pulumi.String("Brett"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Portfolio;
 * import com.pulumi.aws.servicecatalog.PortfolioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var portfolio = new Portfolio("portfolio", PortfolioArgs.builder()
 *             .name("My App Portfolio")
 *             .description("List of my organizations apps")
 *             .providerName("Brett")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   portfolio:
 *     type: aws:servicecatalog:Portfolio
 *     properties:
 *       name: My App Portfolio
 *       description: List of my organizations apps
 *       providerName: Brett
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Catalog Portfolios using the Service Catalog Portfolio `id`. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/portfolio:Portfolio testfolio port-12344321
 * ```
 */
public class Portfolio internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.Portfolio,
) : KotlinCustomResource(javaResource, PortfolioMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Description of the portfolio
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the portfolio.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of the person or organization who owns the portfolio.
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PortfolioMapper : ResourceMapper<Portfolio> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.Portfolio::class == javaResource::class

    override fun map(javaResource: Resource): Portfolio = Portfolio(
        javaResource as
            com.pulumi.aws.servicecatalog.Portfolio,
    )
}

/**
 * @see [Portfolio].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Portfolio].
 */
public suspend fun portfolio(name: String, block: suspend PortfolioResourceBuilder.() -> Unit): Portfolio {
    val builder = PortfolioResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Portfolio].
 * @param name The _unique_ name of the resulting resource.
 */
public fun portfolio(name: String): Portfolio {
    val builder = PortfolioResourceBuilder()
    builder.name(name)
    return builder.build()
}
