@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.PortfolioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a Service Catalog Portfolio.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const portfolio = new aws.servicecatalog.Portfolio("portfolio", {
 *     name: "My App Portfolio",
 *     description: "List of my organizations apps",
 *     providerName: "Brett",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * portfolio = aws.servicecatalog.Portfolio("portfolio",
 *     name="My App Portfolio",
 *     description="List of my organizations apps",
 *     provider_name="Brett")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var portfolio = new Aws.ServiceCatalog.Portfolio("portfolio", new()
 *     {
 *         Name = "My App Portfolio",
 *         Description = "List of my organizations apps",
 *         ProviderName = "Brett",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewPortfolio(ctx, "portfolio", &servicecatalog.PortfolioArgs{
 * 			Name:         pulumi.String("My App Portfolio"),
 * 			Description:  pulumi.String("List of my organizations apps"),
 * 			ProviderName: pulumi.String("Brett"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Portfolio;
 * import com.pulumi.aws.servicecatalog.PortfolioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var portfolio = new Portfolio("portfolio", PortfolioArgs.builder()
 *             .name("My App Portfolio")
 *             .description("List of my organizations apps")
 *             .providerName("Brett")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   portfolio:
 *     type: aws:servicecatalog:Portfolio
 *     properties:
 *       name: My App Portfolio
 *       description: List of my organizations apps
 *       providerName: Brett
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Catalog Portfolios using the Service Catalog Portfolio `id`. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/portfolio:Portfolio testfolio port-12344321
 * ```
 * @property description Description of the portfolio
 * @property name The name of the portfolio.
 * @property providerName Name of the person or organization who owns the portfolio.
 * @property tags Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PortfolioArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.PortfolioArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.PortfolioArgs =
        com.pulumi.aws.servicecatalog.PortfolioArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PortfolioArgs].
 */
@PulumiTagMarker
public class PortfolioArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var providerName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the portfolio
     */
    @JvmName("mmpssbwludhsgjog")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the portfolio.
     */
    @JvmName("sfknviwlkddkulmt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the person or organization who owns the portfolio.
     */
    @JvmName("ygyksgcktoyelmjh")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rtfunvfueuotctec")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the portfolio
     */
    @JvmName("vmnkwktssvqvkvvc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the portfolio.
     */
    @JvmName("hoddlyipsyysqqkv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the person or organization who owns the portfolio.
     */
    @JvmName("abesnslyondnxxjd")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mlnqyoiibujsgfmv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kkldjcfvkidyranv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PortfolioArgs = PortfolioArgs(
        description = description,
        name = name,
        providerName = providerName,
        tags = tags,
    )
}
