@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.PortfolioShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Portfolio Share. Shares the specified portfolio with the specified account or organization node. You can share portfolios to an organization, an organizational unit, or a specific account.
 * If the portfolio share with the specified account or organization node already exists, using this resource to re-create the share will have no effect and will not return an error. You can then use this resource to update the share.
 * > **NOTE:** Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. If a delegated admin is de-registered, they can no longer create portfolio shares.
 * > **NOTE:** AWSOrganizationsAccess must be enabled in order to create a portfolio share to an organization node.
 * > **NOTE:** You can't share a shared resource, including portfolios that contain a shared product.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.PortfolioShare("example", {
 *     principalId: "012128675309",
 *     portfolioId: exampleAwsServicecatalogPortfolio.id,
 *     type: "ACCOUNT",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.PortfolioShare("example",
 *     principal_id="012128675309",
 *     portfolio_id=example_aws_servicecatalog_portfolio["id"],
 *     type="ACCOUNT")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.PortfolioShare("example", new()
 *     {
 *         PrincipalId = "012128675309",
 *         PortfolioId = exampleAwsServicecatalogPortfolio.Id,
 *         Type = "ACCOUNT",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewPortfolioShare(ctx, "example", &servicecatalog.PortfolioShareArgs{
 * 			PrincipalId: pulumi.String("012128675309"),
 * 			PortfolioId: pulumi.Any(exampleAwsServicecatalogPortfolio.Id),
 * 			Type:        pulumi.String("ACCOUNT"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.PortfolioShare;
 * import com.pulumi.aws.servicecatalog.PortfolioShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PortfolioShare("example", PortfolioShareArgs.builder()
 *             .principalId("012128675309")
 *             .portfolioId(exampleAwsServicecatalogPortfolio.id())
 *             .type("ACCOUNT")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:PortfolioShare
 *     properties:
 *       principalId: '012128675309'
 *       portfolioId: ${exampleAwsServicecatalogPortfolio.id}
 *       type: ACCOUNT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_portfolio_share` using the portfolio share ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/portfolioShare:PortfolioShare example port-12344321:ACCOUNT:123456789012
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property portfolioId Portfolio identifier.
 * @property principalId Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
 * @property sharePrincipals Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
 * @property shareTagOptions Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
 * @property type Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
 * The following arguments are optional:
 * @property waitForAcceptance Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
 */
public data class PortfolioShareArgs(
    public val acceptLanguage: Output<String>? = null,
    public val portfolioId: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val sharePrincipals: Output<Boolean>? = null,
    public val shareTagOptions: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val waitForAcceptance: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.PortfolioShareArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.PortfolioShareArgs =
        com.pulumi.aws.servicecatalog.PortfolioShareArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .sharePrincipals(sharePrincipals?.applyValue({ args0 -> args0 }))
            .shareTagOptions(shareTagOptions?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .waitForAcceptance(waitForAcceptance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PortfolioShareArgs].
 */
@PulumiTagMarker
public class PortfolioShareArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var portfolioId: Output<String>? = null

    private var principalId: Output<String>? = null

    private var sharePrincipals: Output<Boolean>? = null

    private var shareTagOptions: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var waitForAcceptance: Output<Boolean>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("xvddhgfhfyloygnn")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("pdfbskqcmslkidju")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
     */
    @JvmName("mkkonoekwkpmblrc")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
     */
    @JvmName("odfisgspywgmofja")
    public suspend fun sharePrincipals(`value`: Output<Boolean>) {
        this.sharePrincipals = value
    }

    /**
     * @param value Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
     */
    @JvmName("ihljgufjkygfosan")
    public suspend fun shareTagOptions(`value`: Output<Boolean>) {
        this.shareTagOptions = value
    }

    /**
     * @param value Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
     * The following arguments are optional:
     */
    @JvmName("wyocfkbexlcswyxe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
     */
    @JvmName("fdenchtytgeafqmr")
    public suspend fun waitForAcceptance(`value`: Output<Boolean>) {
        this.waitForAcceptance = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("msrxakwoarbyyoob")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("wfsfykbfbopoviwe")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
     */
    @JvmName("fruxqkbetdkritjh")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
     */
    @JvmName("yvlbikxeufvkqrfy")
    public suspend fun sharePrincipals(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharePrincipals = mapped
    }

    /**
     * @param value Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
     */
    @JvmName("jhlqcqhcqhwvgmyn")
    public suspend fun shareTagOptions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareTagOptions = mapped
    }

    /**
     * @param value Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
     * The following arguments are optional:
     */
    @JvmName("bastowfmqerjbjub")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
     */
    @JvmName("ajgiameojpfvgmoo")
    public suspend fun waitForAcceptance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForAcceptance = mapped
    }

    internal fun build(): PortfolioShareArgs = PortfolioShareArgs(
        acceptLanguage = acceptLanguage,
        portfolioId = portfolioId,
        principalId = principalId,
        sharePrincipals = sharePrincipals,
        shareTagOptions = shareTagOptions,
        type = type,
        waitForAcceptance = waitForAcceptance,
    )
}
