@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProductPortfolioAssociation].
 */
@PulumiTagMarker
public class ProductPortfolioAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductPortfolioAssociationArgs = ProductPortfolioAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductPortfolioAssociationArgsBuilder.() -> Unit) {
        val builder = ProductPortfolioAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProductPortfolioAssociation {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.ProductPortfolioAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProductPortfolioAssociation(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Product Portfolio Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ProductPortfolioAssociation("example", {
 *     portfolioId: "port-68656c6c6f",
 *     productId: "prod-dnigbtea24ste",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ProductPortfolioAssociation("example",
 *     portfolio_id="port-68656c6c6f",
 *     product_id="prod-dnigbtea24ste")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ProductPortfolioAssociation("example", new()
 *     {
 *         PortfolioId = "port-68656c6c6f",
 *         ProductId = "prod-dnigbtea24ste",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewProductPortfolioAssociation(ctx, "example", &servicecatalog.ProductPortfolioAssociationArgs{
 * 			PortfolioId: pulumi.String("port-68656c6c6f"),
 * 			ProductId:   pulumi.String("prod-dnigbtea24ste"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ProductPortfolioAssociation;
 * import com.pulumi.aws.servicecatalog.ProductPortfolioAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProductPortfolioAssociation("example", ProductPortfolioAssociationArgs.builder()
 *             .portfolioId("port-68656c6c6f")
 *             .productId("prod-dnigbtea24ste")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ProductPortfolioAssociation
 *     properties:
 *       portfolioId: port-68656c6c6f
 *       productId: prod-dnigbtea24ste
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_product_portfolio_association` using the accept language, portfolio ID, and product ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/productPortfolioAssociation:ProductPortfolioAssociation example en:port-68656c6c6f:prod-dnigbtea24ste
 * ```
 */
public class ProductPortfolioAssociation internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.ProductPortfolioAssociation,
) : KotlinCustomResource(javaResource, ProductPortfolioAssociationMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Portfolio identifier.
     */
    public val portfolioId: Output<String>
        get() = javaResource.portfolioId().applyValue({ args0 -> args0 })

    /**
     * Product identifier.
     * The following arguments are optional:
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the source portfolio.
     */
    public val sourcePortfolioId: Output<String>?
        get() = javaResource.sourcePortfolioId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ProductPortfolioAssociationMapper : ResourceMapper<ProductPortfolioAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.ProductPortfolioAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ProductPortfolioAssociation =
        ProductPortfolioAssociation(
            javaResource as
                com.pulumi.aws.servicecatalog.ProductPortfolioAssociation,
        )
}

/**
 * @see [ProductPortfolioAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProductPortfolioAssociation].
 */
public suspend fun productPortfolioAssociation(
    name: String,
    block: suspend ProductPortfolioAssociationResourceBuilder.() -> Unit,
): ProductPortfolioAssociation {
    val builder = ProductPortfolioAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProductPortfolioAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun productPortfolioAssociation(name: String): ProductPortfolioAssociation {
    val builder = ProductPortfolioAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
