@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ProductPortfolioAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Product Portfolio Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ProductPortfolioAssociation("example", {
 *     portfolioId: "port-68656c6c6f",
 *     productId: "prod-dnigbtea24ste",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ProductPortfolioAssociation("example",
 *     portfolio_id="port-68656c6c6f",
 *     product_id="prod-dnigbtea24ste")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ProductPortfolioAssociation("example", new()
 *     {
 *         PortfolioId = "port-68656c6c6f",
 *         ProductId = "prod-dnigbtea24ste",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewProductPortfolioAssociation(ctx, "example", &servicecatalog.ProductPortfolioAssociationArgs{
 * 			PortfolioId: pulumi.String("port-68656c6c6f"),
 * 			ProductId:   pulumi.String("prod-dnigbtea24ste"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ProductPortfolioAssociation;
 * import com.pulumi.aws.servicecatalog.ProductPortfolioAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProductPortfolioAssociation("example", ProductPortfolioAssociationArgs.builder()
 *             .portfolioId("port-68656c6c6f")
 *             .productId("prod-dnigbtea24ste")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ProductPortfolioAssociation
 *     properties:
 *       portfolioId: port-68656c6c6f
 *       productId: prod-dnigbtea24ste
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_product_portfolio_association` using the accept language, portfolio ID, and product ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/productPortfolioAssociation:ProductPortfolioAssociation example en:port-68656c6c6f:prod-dnigbtea24ste
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property portfolioId Portfolio identifier.
 * @property productId Product identifier.
 * The following arguments are optional:
 * @property sourcePortfolioId Identifier of the source portfolio.
 */
public data class ProductPortfolioAssociationArgs(
    public val acceptLanguage: Output<String>? = null,
    public val portfolioId: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val sourcePortfolioId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ProductPortfolioAssociationArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ProductPortfolioAssociationArgs =
        com.pulumi.aws.servicecatalog.ProductPortfolioAssociationArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .sourcePortfolioId(sourcePortfolioId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductPortfolioAssociationArgs].
 */
@PulumiTagMarker
public class ProductPortfolioAssociationArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var portfolioId: Output<String>? = null

    private var productId: Output<String>? = null

    private var sourcePortfolioId: Output<String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("wjusgchswipnncbp")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("usshschjefipksps")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Product identifier.
     * The following arguments are optional:
     */
    @JvmName("yqmnqbrvaydthequ")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Identifier of the source portfolio.
     */
    @JvmName("rjipkekexpmahuki")
    public suspend fun sourcePortfolioId(`value`: Output<String>) {
        this.sourcePortfolioId = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("arodjhhwnxeffgyk")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("ghdpjhhmvbruadvr")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Product identifier.
     * The following arguments are optional:
     */
    @JvmName("tiaqhhvckipaxlqe")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Identifier of the source portfolio.
     */
    @JvmName("gcfowjebcclnfbwa")
    public suspend fun sourcePortfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortfolioId = mapped
    }

    internal fun build(): ProductPortfolioAssociationArgs = ProductPortfolioAssociationArgs(
        acceptLanguage = acceptLanguage,
        portfolioId = portfolioId,
        productId = productId,
        sourcePortfolioId = sourcePortfolioId,
    )
}
