@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.kotlin.outputs.ProvisionedProductOutput
import com.pulumi.aws.servicecatalog.kotlin.outputs.ProvisionedProductProvisioningParameter
import com.pulumi.aws.servicecatalog.kotlin.outputs.ProvisionedProductStackSetProvisioningPreferences
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.servicecatalog.kotlin.outputs.ProvisionedProductOutput.Companion.toKotlin as provisionedProductOutputToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.ProvisionedProductProvisioningParameter.Companion.toKotlin as provisionedProductProvisioningParameterToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.ProvisionedProductStackSetProvisioningPreferences.Companion.toKotlin as provisionedProductStackSetProvisioningPreferencesToKotlin

/**
 * Builder for [ProvisionedProduct].
 */
@PulumiTagMarker
public class ProvisionedProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisionedProductArgs = ProvisionedProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisionedProductArgsBuilder.() -> Unit) {
        val builder = ProvisionedProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProvisionedProduct {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.ProvisionedProduct(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProvisionedProduct(builtJavaResource)
    }
}

/**
 * This resource provisions and manages a Service Catalog provisioned product.
 * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources.
 * Like this resource, the `aws_servicecatalog_record` data source also provides information about a provisioned product. Although a Service Catalog record provides some overlapping information with this resource, a record is tied to a provisioned product event, such as provisioning, termination, and updating.
 * > **Tip:** If you include conflicted keys as tags, AWS will report an error, "Parameter validation failed: Missing required parameter in Tags[N]:Value".
 * > **Tip:** A "provisioning artifact" is also referred to as a "version." A "distributor" is also referred to as a "vendor."
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ProvisionedProduct("example", {
 *     name: "example",
 *     productName: "Example product",
 *     provisioningArtifactName: "Example version",
 *     provisioningParameters: [{
 *         key: "foo",
 *         value: "bar",
 *     }],
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ProvisionedProduct("example",
 *     name="example",
 *     product_name="Example product",
 *     provisioning_artifact_name="Example version",
 *     provisioning_parameters=[{
 *         "key": "foo",
 *         "value": "bar",
 *     }],
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ProvisionedProduct("example", new()
 *     {
 *         Name = "example",
 *         ProductName = "Example product",
 *         ProvisioningArtifactName = "Example version",
 *         ProvisioningParameters = new[]
 *         {
 *             new Aws.ServiceCatalog.Inputs.ProvisionedProductProvisioningParameterArgs
 *             {
 *                 Key = "foo",
 *                 Value = "bar",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewProvisionedProduct(ctx, "example", &servicecatalog.ProvisionedProductArgs{
 * 			Name:                     pulumi.String("example"),
 * 			ProductName:              pulumi.String("Example product"),
 * 			ProvisioningArtifactName: pulumi.String("Example version"),
 * 			ProvisioningParameters: servicecatalog.ProvisionedProductProvisioningParameterArray{
 * 				&servicecatalog.ProvisionedProductProvisioningParameterArgs{
 * 					Key:   pulumi.String("foo"),
 * 					Value: pulumi.String("bar"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ProvisionedProduct;
 * import com.pulumi.aws.servicecatalog.ProvisionedProductArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ProvisionedProductProvisioningParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedProduct("example", ProvisionedProductArgs.builder()
 *             .name("example")
 *             .productName("Example product")
 *             .provisioningArtifactName("Example version")
 *             .provisioningParameters(ProvisionedProductProvisioningParameterArgs.builder()
 *                 .key("foo")
 *                 .value("bar")
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ProvisionedProduct
 *     properties:
 *       name: example
 *       productName: Example product
 *       provisioningArtifactName: Example version
 *       provisioningParameters:
 *         - key: foo
 *           value: bar
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_provisioned_product` using the provisioned product ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/provisionedProduct:ProvisionedProduct example pp-dnigbtea24ste
 * ```
 */
public class ProvisionedProduct internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.ProvisionedProduct,
) : KotlinCustomResource(javaResource, ProvisionedProductMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the provisioned product.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Set of CloudWatch dashboards that were created when provisioning the product.
     */
    public val cloudwatchDashboardNames: Output<List<String>>
        get() = javaResource.cloudwatchDashboardNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Time when the provisioned product was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
     */
    public val ignoreErrors: Output<Boolean>?
        get() = javaResource.ignoreErrors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Record identifier of the last request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
     */
    public val lastProvisioningRecordId: Output<String>
        get() = javaResource.lastProvisioningRecordId().applyValue({ args0 -> args0 })

    /**
     * Record identifier of the last request performed on this provisioned product.
     */
    public val lastRecordId: Output<String>
        get() = javaResource.lastRecordId().applyValue({ args0 -> args0 })

    /**
     * Record identifier of the last successful request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
     */
    public val lastSuccessfulProvisioningRecordId: Output<String>
        get() = javaResource.lastSuccessfulProvisioningRecordId().applyValue({ args0 -> args0 })

    /**
     * ARN of the launch role associated with the provisioned product.
     */
    public val launchRoleArn: Output<String>
        get() = javaResource.launchRoleArn().applyValue({ args0 -> args0 })

    /**
     * User-friendly name of the provisioned product.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    public val notificationArns: Output<List<String>>?
        get() = javaResource.notificationArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The set of outputs for the product created.
     */
    public val outputs: Output<List<ProvisionedProductOutput>>
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    provisionedProductOutputToKotlin(args0)
                })
            })
        })

    /**
     * Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `aws.servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
     */
    public val pathId: Output<String>
        get() = javaResource.pathId().applyValue({ args0 -> args0 })

    /**
     * Name of the path. You must provide `path_id` or `path_name`, but not both.
     */
    public val pathName: Output<String>?
        get() = javaResource.pathName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    /**
     * Name of the product. You must provide `product_id` or `product_name`, but not both.
     */
    public val productName: Output<String>?
        get() = javaResource.productName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
     */
    public val provisioningArtifactId: Output<String>
        get() = javaResource.provisioningArtifactId().applyValue({ args0 -> args0 })

    /**
     * Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
     */
    public val provisioningArtifactName: Output<String>?
        get() = javaResource.provisioningArtifactName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    public val provisioningParameters: Output<List<ProvisionedProductProvisioningParameter>>?
        get() = javaResource.provisioningParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        provisionedProductProvisioningParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
     */
    public val retainPhysicalResources: Output<Boolean>?
        get() = javaResource.retainPhysicalResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block with information about the provisioning preferences for a stack set. See `stack_set_provisioning_preferences` Block for details.
     */
    public val stackSetProvisioningPreferences:
        Output<ProvisionedProductStackSetProvisioningPreferences>?
        get() = javaResource.stackSetProvisioningPreferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    provisionedProductStackSetProvisioningPreferencesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Current status of the provisioned product. See meanings below.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Current status message of the provisioned product.
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of provisioned product. Valid values are `CFN_STACK` and `CFN_STACKSET`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProvisionedProductMapper : ResourceMapper<ProvisionedProduct> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.ProvisionedProduct::class == javaResource::class

    override fun map(javaResource: Resource): ProvisionedProduct = ProvisionedProduct(
        javaResource as
            com.pulumi.aws.servicecatalog.ProvisionedProduct,
    )
}

/**
 * @see [ProvisionedProduct].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisionedProduct].
 */
public suspend fun provisionedProduct(
    name: String,
    block: suspend ProvisionedProductResourceBuilder.() -> Unit,
): ProvisionedProduct {
    val builder = ProvisionedProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisionedProduct].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisionedProduct(name: String): ProvisionedProduct {
    val builder = ProvisionedProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
