@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ProvisionedProductArgs.builder
import com.pulumi.aws.servicecatalog.kotlin.inputs.ProvisionedProductProvisioningParameterArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.ProvisionedProductProvisioningParameterArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.ProvisionedProductStackSetProvisioningPreferencesArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.ProvisionedProductStackSetProvisioningPreferencesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This resource provisions and manages a Service Catalog provisioned product.
 * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources.
 * Like this resource, the `aws_servicecatalog_record` data source also provides information about a provisioned product. Although a Service Catalog record provides some overlapping information with this resource, a record is tied to a provisioned product event, such as provisioning, termination, and updating.
 * > **Tip:** If you include conflicted keys as tags, AWS will report an error, "Parameter validation failed: Missing required parameter in Tags[N]:Value".
 * > **Tip:** A "provisioning artifact" is also referred to as a "version." A "distributor" is also referred to as a "vendor."
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ProvisionedProduct("example", {
 *     name: "example",
 *     productName: "Example product",
 *     provisioningArtifactName: "Example version",
 *     provisioningParameters: [{
 *         key: "foo",
 *         value: "bar",
 *     }],
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ProvisionedProduct("example",
 *     name="example",
 *     product_name="Example product",
 *     provisioning_artifact_name="Example version",
 *     provisioning_parameters=[{
 *         "key": "foo",
 *         "value": "bar",
 *     }],
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ProvisionedProduct("example", new()
 *     {
 *         Name = "example",
 *         ProductName = "Example product",
 *         ProvisioningArtifactName = "Example version",
 *         ProvisioningParameters = new[]
 *         {
 *             new Aws.ServiceCatalog.Inputs.ProvisionedProductProvisioningParameterArgs
 *             {
 *                 Key = "foo",
 *                 Value = "bar",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewProvisionedProduct(ctx, "example", &servicecatalog.ProvisionedProductArgs{
 * 			Name:                     pulumi.String("example"),
 * 			ProductName:              pulumi.String("Example product"),
 * 			ProvisioningArtifactName: pulumi.String("Example version"),
 * 			ProvisioningParameters: servicecatalog.ProvisionedProductProvisioningParameterArray{
 * 				&servicecatalog.ProvisionedProductProvisioningParameterArgs{
 * 					Key:   pulumi.String("foo"),
 * 					Value: pulumi.String("bar"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ProvisionedProduct;
 * import com.pulumi.aws.servicecatalog.ProvisionedProductArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ProvisionedProductProvisioningParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedProduct("example", ProvisionedProductArgs.builder()
 *             .name("example")
 *             .productName("Example product")
 *             .provisioningArtifactName("Example version")
 *             .provisioningParameters(ProvisionedProductProvisioningParameterArgs.builder()
 *                 .key("foo")
 *                 .value("bar")
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ProvisionedProduct
 *     properties:
 *       name: example
 *       productName: Example product
 *       provisioningArtifactName: Example version
 *       provisioningParameters:
 *         - key: foo
 *           value: bar
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_provisioned_product` using the provisioned product ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/provisionedProduct:ProvisionedProduct example pp-dnigbtea24ste
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property ignoreErrors _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
 * @property name User-friendly name of the provisioned product.
 * The following arguments are optional:
 * @property notificationArns Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
 * @property pathId Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `aws.servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
 * @property pathName Name of the path. You must provide `path_id` or `path_name`, but not both.
 * @property productId Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
 * @property productName Name of the product. You must provide `product_id` or `product_name`, but not both.
 * @property provisioningArtifactId Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
 * @property provisioningArtifactName Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
 * @property provisioningParameters Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
 * @property retainPhysicalResources _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
 * @property stackSetProvisioningPreferences Configuration block with information about the provisioning preferences for a stack set. See `stack_set_provisioning_preferences` Block for details.
 * @property tags Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProvisionedProductArgs(
    public val acceptLanguage: Output<String>? = null,
    public val ignoreErrors: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val notificationArns: Output<List<String>>? = null,
    public val pathId: Output<String>? = null,
    public val pathName: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val productName: Output<String>? = null,
    public val provisioningArtifactId: Output<String>? = null,
    public val provisioningArtifactName: Output<String>? = null,
    public val provisioningParameters: Output<List<ProvisionedProductProvisioningParameterArgs>>? =
        null,
    public val retainPhysicalResources: Output<Boolean>? = null,
    public val stackSetProvisioningPreferences: Output<ProvisionedProductStackSetProvisioningPreferencesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ProvisionedProductArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ProvisionedProductArgs =
        com.pulumi.aws.servicecatalog.ProvisionedProductArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .ignoreErrors(ignoreErrors?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationArns(notificationArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .pathId(pathId?.applyValue({ args0 -> args0 }))
            .pathName(pathName?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 }))
            .provisioningArtifactId(provisioningArtifactId?.applyValue({ args0 -> args0 }))
            .provisioningArtifactName(provisioningArtifactName?.applyValue({ args0 -> args0 }))
            .provisioningParameters(
                provisioningParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .retainPhysicalResources(retainPhysicalResources?.applyValue({ args0 -> args0 }))
            .stackSetProvisioningPreferences(
                stackSetProvisioningPreferences?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProvisionedProductArgs].
 */
@PulumiTagMarker
public class ProvisionedProductArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var ignoreErrors: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var notificationArns: Output<List<String>>? = null

    private var pathId: Output<String>? = null

    private var pathName: Output<String>? = null

    private var productId: Output<String>? = null

    private var productName: Output<String>? = null

    private var provisioningArtifactId: Output<String>? = null

    private var provisioningArtifactName: Output<String>? = null

    private var provisioningParameters: Output<List<ProvisionedProductProvisioningParameterArgs>>? =
        null

    private var retainPhysicalResources: Output<Boolean>? = null

    private var stackSetProvisioningPreferences:
        Output<ProvisionedProductStackSetProvisioningPreferencesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("fvpxudmayifqvisb")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
     */
    @JvmName("kimvroaafgyuivuf")
    public suspend fun ignoreErrors(`value`: Output<Boolean>) {
        this.ignoreErrors = value
    }

    /**
     * @param value User-friendly name of the provisioned product.
     * The following arguments are optional:
     */
    @JvmName("vjhfdgqqxcxbeept")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    @JvmName("oqxnxmqacrkaoiyj")
    public suspend fun notificationArns(`value`: Output<List<String>>) {
        this.notificationArns = value
    }

    @JvmName("vtbnfgsvgaxxihfy")
    public suspend fun notificationArns(vararg values: Output<String>) {
        this.notificationArns = Output.all(values.asList())
    }

    /**
     * @param values Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    @JvmName("bmwgxtglyvtamoso")
    public suspend fun notificationArns(values: List<Output<String>>) {
        this.notificationArns = Output.all(values)
    }

    /**
     * @param value Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `aws.servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
     */
    @JvmName("xtibdyenwgvmuaub")
    public suspend fun pathId(`value`: Output<String>) {
        this.pathId = value
    }

    /**
     * @param value Name of the path. You must provide `path_id` or `path_name`, but not both.
     */
    @JvmName("pxwkgayqbjwtdnbj")
    public suspend fun pathName(`value`: Output<String>) {
        this.pathName = value
    }

    /**
     * @param value Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
     */
    @JvmName("cksevlbdgkormayb")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Name of the product. You must provide `product_id` or `product_name`, but not both.
     */
    @JvmName("cxhcssbiafouahiv")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
     */
    @JvmName("gnjjbbjcwiawwvfx")
    public suspend fun provisioningArtifactId(`value`: Output<String>) {
        this.provisioningArtifactId = value
    }

    /**
     * @param value Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
     */
    @JvmName("ctdqumdfmccqqhfv")
    public suspend fun provisioningArtifactName(`value`: Output<String>) {
        this.provisioningArtifactName = value
    }

    /**
     * @param value Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("niarrtqpqinxelqj")
    public suspend fun provisioningParameters(`value`: Output<List<ProvisionedProductProvisioningParameterArgs>>) {
        this.provisioningParameters = value
    }

    @JvmName("gpwcamatxittxnub")
    public suspend fun provisioningParameters(vararg values: Output<ProvisionedProductProvisioningParameterArgs>) {
        this.provisioningParameters = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("domgoiseweceabpb")
    public suspend fun provisioningParameters(values: List<Output<ProvisionedProductProvisioningParameterArgs>>) {
        this.provisioningParameters = Output.all(values)
    }

    /**
     * @param value _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
     */
    @JvmName("ljovbruvyijbnqsl")
    public suspend fun retainPhysicalResources(`value`: Output<Boolean>) {
        this.retainPhysicalResources = value
    }

    /**
     * @param value Configuration block with information about the provisioning preferences for a stack set. See `stack_set_provisioning_preferences` Block for details.
     */
    @JvmName("douwlgqsjjpnwvcl")
    public suspend fun stackSetProvisioningPreferences(`value`: Output<ProvisionedProductStackSetProvisioningPreferencesArgs>) {
        this.stackSetProvisioningPreferences = value
    }

    /**
     * @param value Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wbsbfvqabjmpodfc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("vuybguiefelxqyey")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
     */
    @JvmName("ftajtekxohxvawuk")
    public suspend fun ignoreErrors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreErrors = mapped
    }

    /**
     * @param value User-friendly name of the provisioned product.
     * The following arguments are optional:
     */
    @JvmName("dubvqvlkfminweeb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    @JvmName("hjruoslcfneukqud")
    public suspend fun notificationArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationArns = mapped
    }

    /**
     * @param values Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    @JvmName("moxdxysppnmkvbjr")
    public suspend fun notificationArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationArns = mapped
    }

    /**
     * @param value Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `aws.servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
     */
    @JvmName("kivofwhwsaygvcmh")
    public suspend fun pathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathId = mapped
    }

    /**
     * @param value Name of the path. You must provide `path_id` or `path_name`, but not both.
     */
    @JvmName("krxqviwraskwnqaa")
    public suspend fun pathName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathName = mapped
    }

    /**
     * @param value Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
     */
    @JvmName("eufewrphpflaflmh")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Name of the product. You must provide `product_id` or `product_name`, but not both.
     */
    @JvmName("ihyknamxxhgibrha")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
     */
    @JvmName("uldnebfluraodysx")
    public suspend fun provisioningArtifactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningArtifactId = mapped
    }

    /**
     * @param value Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
     */
    @JvmName("axbkigaucglhxmgw")
    public suspend fun provisioningArtifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningArtifactName = mapped
    }

    /**
     * @param value Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("ixsjttonpkrrcscq")
    public suspend fun provisioningParameters(`value`: List<ProvisionedProductProvisioningParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningParameters = mapped
    }

    /**
     * @param argument Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("phfrkhvltejsnmnv")
    public suspend fun provisioningParameters(argument: List<suspend ProvisionedProductProvisioningParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProvisionedProductProvisioningParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.provisioningParameters = mapped
    }

    /**
     * @param argument Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("gkuaxsccbyisglgw")
    public suspend fun provisioningParameters(vararg argument: suspend ProvisionedProductProvisioningParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProvisionedProductProvisioningParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.provisioningParameters = mapped
    }

    /**
     * @param argument Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("ahbebdxwfmpknces")
    public suspend fun provisioningParameters(argument: suspend ProvisionedProductProvisioningParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProvisionedProductProvisioningParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.provisioningParameters = mapped
    }

    /**
     * @param values Configuration block with parameters specified by the administrator that are required for provisioning the product. See `provisioning_parameters` Block for details.
     */
    @JvmName("woudwlucyhomioit")
    public suspend fun provisioningParameters(vararg values: ProvisionedProductProvisioningParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningParameters = mapped
    }

    /**
     * @param value _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
     */
    @JvmName("wqspgeiigjeodrko")
    public suspend fun retainPhysicalResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainPhysicalResources = mapped
    }

    /**
     * @param value Configuration block with information about the provisioning preferences for a stack set. See `stack_set_provisioning_preferences` Block for details.
     */
    @JvmName("wubprwvgcomlckgy")
    public suspend fun stackSetProvisioningPreferences(`value`: ProvisionedProductStackSetProvisioningPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackSetProvisioningPreferences = mapped
    }

    /**
     * @param argument Configuration block with information about the provisioning preferences for a stack set. See `stack_set_provisioning_preferences` Block for details.
     */
    @JvmName("sylmlghpvtfprjfo")
    public suspend fun stackSetProvisioningPreferences(argument: suspend ProvisionedProductStackSetProvisioningPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedProductStackSetProvisioningPreferencesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stackSetProvisioningPreferences = mapped
    }

    /**
     * @param value Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("grgfvbtgmeapmxdu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rhiyqiabeoejhafh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProvisionedProductArgs = ProvisionedProductArgs(
        acceptLanguage = acceptLanguage,
        ignoreErrors = ignoreErrors,
        name = name,
        notificationArns = notificationArns,
        pathId = pathId,
        pathName = pathName,
        productId = productId,
        productName = productName,
        provisioningArtifactId = provisioningArtifactId,
        provisioningArtifactName = provisioningArtifactName,
        provisioningParameters = provisioningParameters,
        retainPhysicalResources = retainPhysicalResources,
        stackSetProvisioningPreferences = stackSetProvisioningPreferences,
        tags = tags,
    )
}
